/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GobletBlockTile
extends BlockEntity
implements ISoftFluidTankProvider,
IExtraModelDataProvider {
    public final SoftFluidTank fluidHolder = SoftFluidTank.create((int)1, (HolderLookup.Provider)Utils.hackyGetRegistryAccess());
    public static final ModelDataKey<ResourceKey<SoftFluid>> FLUID_ID = ModBlockProperties.FLUID;

    public GobletBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.GOBLET_TILE.get(), pos, state);
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        SoftFluidTank softFluidTank = this.getSoftFluidTank();
        if (!softFluidTank.isEmpty()) {
            builder.with(FLUID_ID, (Object)((ResourceKey)softFluidTank.getFluid().getHolder().unwrapKey().get()));
        }
    }

    public void setChanged() {
        if (this.level == null) {
            return;
        }
        this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
        int light = this.fluidHolder.getFluidValue().getLuminosity();
        if (light != (Integer)this.getBlockState().getValue((Property)ModBlockProperties.LIGHT_LEVEL_0_15)) {
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)ModBlockProperties.LIGHT_LEVEL_0_15, (Comparable)Integer.valueOf(light)), 2);
        }
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        super.setChanged();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.fluidHolder.load(tag, registries);
        if (this.level != null && this.level.isClientSide) {
            this.requestModelReload();
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.fluidHolder.save(tag, registries);
    }

    public SoftFluidTank getSoftFluidTank() {
        return this.fluidHolder;
    }
}

