/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpeakerBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class SpeakerBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty ANTIQUE = ModBlockProperties.ANTIQUE;
    private static final int POWERED_TICKS = 40;

    public SpeakerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ANTIQUE, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED, ANTIQUE});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        boolean hasPower;
        super.neighborChanged(state, level, pos, neighborBlock, fromPos, moving);
        if (!level.isClientSide && (hasPower = ((Boolean)state.getValue((Property)POWERED)).booleanValue()) != level.hasNeighborSignal(pos)) {
            if (hasPower) {
                level.scheduleTick(pos, (Block)this, 40);
            } else {
                this.updatePower(state, level, pos);
            }
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.updatePower(state, (Level)level, pos);
    }

    public void updatePower(BlockState state, Level world, BlockPos pos) {
        boolean pow;
        if (!world.isClientSide() && (pow = world.hasNeighborSignal(pos)) != (Boolean)state.getValue((Property)POWERED)) {
            BlockEntity blockEntity;
            world.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(pow)), 2);
            Direction facing = (Direction)state.getValue((Property)FACING);
            if (pow && world.isEmptyBlock(pos.relative(facing)) && (blockEntity = world.getBlockEntity(pos)) instanceof SpeakerBlockTile) {
                SpeakerBlockTile tile = (SpeakerBlockTile)blockEntity;
                tile.sendMessage();
                world.gameEvent(null, (Holder)GameEvent.INSTRUMENT_PLAY, pos);
            }
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SpeakerBlockTile) {
            ServerPlayer serverPlayer;
            SpeakerBlockTile tile = (SpeakerBlockTile)blockEntity;
            if (!((Boolean)state.getValue((Property)ANTIQUE)).booleanValue() && Utils.mayPerformBlockAction((Player)player, (BlockPos)pos, (ItemStack)stack) && stack.is(ModRegistry.ANTIQUE_INK.get())) {
                level.playSound(null, pos, SoundEvents.INK_SAC_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ANTIQUE, (Comparable)Boolean.valueOf(true)));
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)level.getBlockState(pos)));
                stack.consume(1, (LivingEntity)player);
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, stack);
                    player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                tile.tryOpeningEditGui(serverPlayer, pos, stack, hitResult.getDirection());
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new SpeakerBlockTile(pPos, pState);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        if (eventID == 0) {
            Direction facing = (Direction)state.getValue((Property)FACING);
            world.addParticle((ParticleOptions)ModParticles.SPEAKER_SOUND.get(), (double)pos.getX() + 0.5 + (double)facing.getStepX() * 0.725, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5 + (double)facing.getStepZ() * 0.725, (double)world.random.nextInt(24) / 24.0, 0.0, 0.0);
            return true;
        }
        return super.triggerEvent(state, world, pos, eventID, eventParam);
    }
}

