/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.player.expiration;

import java.util.Objects;
import net.minecraft.server.MinecraftServer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.claims.player.PlayerChunkClaim;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.ServerClaimsManager;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.claims.player.ServerPlayerClaimInfo;
import xaero.pac.common.server.claims.player.ServerPlayerClaimInfoManager;
import xaero.pac.common.server.claims.player.task.IPlayerClaimReplaceSpreadoutTaskCallback;
import xaero.pac.common.server.claims.player.task.PlayerClaimReplaceSpreadoutTask;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.expiration.ObjectExpirationHandler;
import xaero.pac.common.server.info.ServerInfo;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.PlayerConfig;

public final class ServerPlayerClaimsExpirationHandler
extends ObjectExpirationHandler<ServerPlayerClaimInfo, ServerPlayerClaimInfoManager> {
    private final ServerClaimsManager claimsManager;
    private final MinecraftServer server;

    protected ServerPlayerClaimsExpirationHandler(ServerClaimsManager claimsManager, ServerInfo serverInfo, MinecraftServer server, ServerPlayerClaimInfoManager manager, long liveCheckInterval, long expirationTime, String checkingMessage) {
        super(serverInfo, manager, liveCheckInterval, expirationTime, checkingMessage);
        this.claimsManager = claimsManager;
        this.server = server;
    }

    @Override
    protected void handle(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return;
        }
        super.handle(serverData);
    }

    @Override
    public void preExpirationCheck(ServerPlayerClaimInfo playerInfo) {
    }

    @Override
    public boolean checkIfActive(ServerPlayerClaimInfo playerInfo) {
        return Objects.equals(PlayerConfig.EXPIRED_CLAIM_UUID, playerInfo.getPlayerId()) || Objects.equals(PlayerConfig.SERVER_CLAIM_UUID, playerInfo.getPlayerId()) || this.server.getPlayerList().getPlayer(playerInfo.getPlayerId()) != null;
    }

    @Override
    public boolean expire(ServerPlayerClaimInfo playerInfo, IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData) {
        PlayerChunkClaim toReplaceWith = (Boolean)ServerConfig.CONFIG.playerClaimsConvertExpiredClaims.get() != false ? new PlayerChunkClaim(PlayerConfig.EXPIRED_CLAIM_UUID, -1, false, 0) : null;
        SpreadoutTaskCallback spreadoutTaskCallback = new SpreadoutTaskCallback(playerInfo);
        playerInfo.addReplacementTask(new PlayerClaimReplaceSpreadoutTask(spreadoutTaskCallback, playerInfo.getPlayerId(), s -> true, toReplaceWith), serverData);
        return false;
    }

    public class SpreadoutTaskCallback
    implements IPlayerClaimReplaceSpreadoutTaskCallback {
        private final ServerPlayerClaimInfo playerInfo;

        public SpreadoutTaskCallback(ServerPlayerClaimInfo playerInfo) {
            this.playerInfo = playerInfo;
        }

        @Override
        public void onWork(int tickCount) {
        }

        @Override
        public void onFinish(PlayerClaimReplaceSpreadoutTask.ResultType resultType, int tickCount, int totalCount, IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData) {
            if (resultType.isSuccess()) {
                ((ServerPlayerClaimInfoManager)ServerPlayerClaimsExpirationHandler.this.manager).tryRemove(this.playerInfo.getPlayerId());
            }
            ServerPlayerClaimsExpirationHandler.this.onElementExpirationDone();
        }
    }

    public static final class Builder
    extends ObjectExpirationHandler.Builder<ServerPlayerClaimInfo, ServerPlayerClaimInfoManager, Builder> {
        private ServerClaimsManager claimsManager;
        private MinecraftServer server;

        @Override
        public Builder setDefault() {
            super.setDefault();
            this.setClaimsManager(null);
            this.setServer(null);
            this.setCheckingMessage("Checking for expired player claims...");
            this.setExpirationTime((long)((Integer)ServerConfig.CONFIG.playerClaimsExpirationTime.get()).intValue() * 60L * 60L * 1000L);
            this.setLiveCheckInterval((long)((Integer)ServerConfig.CONFIG.playerClaimsExpirationCheckInterval.get()).intValue() * 60000L);
            return this;
        }

        public Builder setClaimsManager(ServerClaimsManager claimsManager) {
            this.claimsManager = claimsManager;
            return this;
        }

        public Builder setServer(MinecraftServer server) {
            this.server = server;
            return this;
        }

        public ServerPlayerClaimsExpirationHandler build() {
            if (this.server == null || this.claimsManager == null) {
                throw new IllegalStateException();
            }
            return (ServerPlayerClaimsExpirationHandler)super.build();
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }

        @Override
        protected ObjectExpirationHandler<ServerPlayerClaimInfo, ServerPlayerClaimInfoManager> buildInternally() {
            return new ServerPlayerClaimsExpirationHandler(this.claimsManager, this.serverInfo, this.server, (ServerPlayerClaimInfoManager)this.manager, this.liveCheckInterval, this.expirationTime, this.checkingMessage);
        }
    }
}

