/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.mixin.create;

import com.simibubi.create.content.fluids.OpenEndedPipe;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.pac.common.server.core.ServerCore;

@Mixin(value={OpenEndedPipe.class})
public class MixinNeoForgeOpenEndedPipe {
    @Shadow
    private Level world;
    @Shadow
    private BlockPos pos;
    @Shadow
    private BlockPos outputPos;

    @Inject(method={"provideFluidToSpace"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getBlockState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", ordinal=0)}, cancellable=true)
    public void onProvideFluidToSpace(FluidStack fluid, boolean simulate, CallbackInfoReturnable<Boolean> cir) {
        if (!ServerCore.canCreatePipeAffectBlock(this.world, this.pos, this.outputPos, simulate)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"removeFluidFromSpace"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getBlockState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", ordinal=0)}, cancellable=true)
    public void onRemoveFluidFromSpace(boolean simulate, CallbackInfoReturnable<FluidStack> cir) {
        if (!ServerCore.canCreatePipeAffectBlock(this.world, this.pos, this.outputPos, simulate)) {
            cir.setReturnValue((Object)FluidStack.EMPTY);
        }
    }
}

