/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.mixins.neoforge;

import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.neoforge.ExtraModelDataImpl;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.extensions.IBlockEntityExtension;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={IExtraModelDataProvider.class})
public interface SelfExtraModelDataProvider
extends IBlockEntityExtension,
IExtraModelDataProvider {
    @Override
    @Overwrite
    default public void requestModelReload() {
        BlockEntity be = (BlockEntity)this;
        be.requestModelDataUpdate();
        Level level = be.getLevel();
        if (level != null && level.isClientSide) {
            level.sendBlockUpdated(be.getBlockPos(), be.getBlockState(), be.getBlockState(), 2);
        }
    }

    default public ModelData getModelData() {
        ExtraModelData extraModelData = this.getExtraModelData();
        if (extraModelData instanceof ExtraModelDataImpl) {
            ExtraModelDataImpl data = (ExtraModelDataImpl)extraModelData;
            return data.data();
        }
        return ModelData.EMPTY;
    }

    default public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        BlockEntity be = (BlockEntity)this;
        Level level = be.getLevel();
        if (level != null && level.isClientSide) {
            ExtraModelData oldData = this.getExtraModelData();
            CompoundTag tag = pkt.getTag();
            if (!tag.isEmpty()) {
                super.onDataPacket(net, pkt, registries);
                this.afterDataPacket(oldData);
            }
        }
    }
}

