/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.fake_player;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Stat;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.Nullable;

public class FakeGenericPlayer
extends Player {
    private static final boolean HAS_CACHE = PlatHelper.getPlatform().isForge();
    private static final WeakHashMap<Level, Map<GameProfile, FakeGenericPlayer>> FAKE_PLAYERS = new WeakHashMap();

    public static FakeGenericPlayer get(Level level, GameProfile username) {
        if (!HAS_CACHE) {
            return new FakeGenericPlayer(level, username);
        }
        return FAKE_PLAYERS.computeIfAbsent(level, l -> new HashMap()).computeIfAbsent(username, u -> new FakeGenericPlayer(level, username));
    }

    public static void unloadLevel(LevelAccessor level) {
        FAKE_PLAYERS.entrySet().removeIf(e -> e.getKey() == level);
    }

    public FakeGenericPlayer(Level level, GameProfile gameProfile) {
        super(level, BlockPos.ZERO, 0.0f, gameProfile);
    }

    public boolean isSpectator() {
        return false;
    }

    public boolean isCreative() {
        return false;
    }

    public void displayClientMessage(Component chatComponent, boolean actionBar) {
    }

    public void awardStat(Stat stat, int increment) {
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return true;
    }

    public boolean canHarmPlayer(Player other) {
        return false;
    }

    public void die(DamageSource damageSource) {
    }

    public void tick() {
    }

    @Nullable
    public MinecraftServer getServer() {
        return PlatHelper.getCurrentServer();
    }
}

