/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.block;

import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.client.IScreenProvider;
import net.mehvahdjukaar.moonlight.api.misc.TileOrEntityTarget;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public interface IOnePlayerInteractable {
    public void setPlayerWhoMayEdit(@Nullable UUID var1);

    public UUID getPlayerWhoMayEdit();

    default public boolean isEditingPlayer(BlockPos myPos, Player player) {
        if (player.level().isClientSide) {
            return this.isCloseEnoughToEdit(player, myPos);
        }
        this.validateEditingPlayer(myPos, player.level());
        UUID uuid = this.getPlayerWhoMayEdit();
        return uuid != null && uuid.equals(player.getUUID());
    }

    default public boolean isOtherPlayerEditing(BlockPos myPos, Player otherThan) {
        this.validateEditingPlayer(myPos, otherThan.level());
        UUID uuid = this.getPlayerWhoMayEdit();
        return uuid != null && !uuid.equals(otherThan.getUUID());
    }

    private void validateEditingPlayer(BlockPos myPos, Level level) {
        if (level == null) {
            this.setPlayerWhoMayEdit(null);
            return;
        }
        UUID uuid = this.getPlayerWhoMayEdit();
        if (uuid == null) {
            return;
        }
        Player player = level.getPlayerByUUID(uuid);
        if (player == null || !this.isCloseEnoughToEdit(player, myPos)) {
            this.setPlayerWhoMayEdit(null);
        }
    }

    private boolean isCloseEnoughToEdit(Player player, BlockPos myPos) {
        return player.canInteractWithBlock(myPos, 8.0);
    }

    default public boolean tryOpeningEditGui(ServerPlayer player, BlockPos pos, ItemStack stack, Direction hitFace) {
        if (Utils.mayPerformBlockAction((Player)player, pos, stack) && !this.isOtherPlayerEditing(pos, (Player)player)) {
            this.setPlayerWhoMayEdit(player.getUUID());
            IOnePlayerInteractable iOnePlayerInteractable = this;
            if (iOnePlayerInteractable instanceof IScreenProvider) {
                IScreenProvider sp = (IScreenProvider)((Object)iOnePlayerInteractable);
                sp.sendOpenGuiPacket(player, hitFace);
                return false;
            }
            IOnePlayerInteractable iOnePlayerInteractable2 = this;
            if (iOnePlayerInteractable2 instanceof MenuProvider) {
                MenuProvider mp = (MenuProvider)iOnePlayerInteractable2;
                iOnePlayerInteractable2 = this;
                if (iOnePlayerInteractable2 instanceof BlockEntity) {
                    BlockEntity be = (BlockEntity)iOnePlayerInteractable2;
                    TileOrEntityTarget target = TileOrEntityTarget.of(be);
                    PlatHelper.openCustomMenu(player, mp, target::write);
                    return true;
                }
            }
        }
        return false;
    }
}

