/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.util.weighted;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.worldgen.lithostitched.util.weighted.Weighted;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;

public final class WeightedList<E> {
    private final int totalWeight;
    private final List<Weighted<E>> items;
    @Nullable
    private final Selector<E> selector;

    WeightedList(List<? extends Weighted<E>> $$0) {
        this.items = List.copyOf($$0);
        this.totalWeight = WeightedList.getTotalWeight($$0, Weighted::weight);
        this.selector = this.totalWeight == 0 ? null : (this.totalWeight < 64 ? new Flat<E>(this.items, this.totalWeight) : new Compact<E>(this.items));
    }

    public static <T> int getTotalWeight(List<T> list, ToIntFunction<T> toIntFunction) {
        long l = 0L;
        for (T object : list) {
            l += (long)toIntFunction.applyAsInt(object);
        }
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Sum of weights must be <= 2147483647");
        }
        return (int)l;
    }

    public static <E> WeightedList<E> of() {
        return new WeightedList<E>(List.of());
    }

    public static <E> WeightedList<E> of(E entry) {
        return new WeightedList<E>(List.of(new Weighted<E>(entry, 1)));
    }

    @SafeVarargs
    public static <E> WeightedList<E> of(Weighted<E> ... entries) {
        return new WeightedList<E>(List.of(entries));
    }

    public static <E> WeightedList<E> of(List<Weighted<E>> entries) {
        return new WeightedList<E>(entries);
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public <T> WeightedList<T> map(Function<E, T> $$0) {
        return new WeightedList<E>(Lists.transform(this.items, $$1 -> $$1.map($$0)));
    }

    public Optional<E> getRandom(RandomSource $$0) {
        if (this.selector == null) {
            return Optional.empty();
        }
        int $$1 = $$0.nextInt(this.totalWeight);
        return Optional.of(this.selector.get($$1));
    }

    public E getRandomOrThrow(RandomSource $$0) {
        if (this.selector == null) {
            throw new IllegalStateException("Weighted list has no elements");
        }
        int $$1 = $$0.nextInt(this.totalWeight);
        return this.selector.get($$1);
    }

    public List<Weighted<E>> unwrap() {
        return this.items;
    }

    public static <E> Codec<WeightedList<E>> codec(Codec<E> $$0) {
        return Weighted.codec($$0).listOf().xmap(WeightedList::of, WeightedList::unwrap);
    }

    public static <E> Codec<WeightedList<E>> codec(MapCodec<E> $$0) {
        return Weighted.codec($$0).listOf().xmap(WeightedList::of, WeightedList::unwrap);
    }

    public static <E> Codec<WeightedList<E>> nonEmptyCodec(Codec<E> $$0) {
        return ExtraCodecs.nonEmptyList((Codec)Weighted.codec($$0).listOf()).xmap(WeightedList::of, WeightedList::unwrap);
    }

    public static <E> Codec<WeightedList<E>> nonEmptyCodec(MapCodec<E> $$0) {
        return ExtraCodecs.nonEmptyList((Codec)Weighted.codec($$0).listOf()).xmap(WeightedList::of, WeightedList::unwrap);
    }

    public boolean contains(E $$0) {
        for (Weighted<E> $$1 : this.items) {
            if (!$$1.value().equals($$0)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof WeightedList)) {
            return false;
        }
        WeightedList thatList = (WeightedList)that;
        return this.totalWeight == thatList.totalWeight && Objects.equals(this.items, thatList.items);
    }

    public int hashCode() {
        int $$0 = this.totalWeight;
        $$0 = 31 * $$0 + this.items.hashCode();
        return $$0;
    }

    static interface Selector<E> {
        public E get(int var1);
    }

    static class Flat<E>
    implements Selector<E> {
        private final Object[] entries;

        Flat(List<Weighted<E>> entries, int $$1) {
            this.entries = new Object[$$1];
            int $$2 = 0;
            for (Weighted<E> entry : entries) {
                int $$4 = entry.weight();
                Arrays.fill(this.entries, $$2, $$2 + $$4, entry.value());
                $$2 += $$4;
            }
        }

        @Override
        public E get(int value) {
            return (E)this.entries[value];
        }
    }

    static class Compact<E>
    implements Selector<E> {
        private final Weighted[] entries;

        Compact(List<Weighted<E>> entries) {
            this.entries = (Weighted[])entries.toArray(Weighted[]::new);
        }

        @Override
        public E get(int value) {
            for (Weighted entry : this.entries) {
                if ((value -= entry.weight()) >= 0) continue;
                return (E)entry.value();
            }
            throw new IllegalStateException(value + " exceeded total weight");
        }
    }

    public static class Builder<E> {
        private final ImmutableList.Builder<Weighted<E>> result = ImmutableList.builder();

        public Builder<E> add(E $$0) {
            return this.add($$0, 1);
        }

        public Builder<E> add(E $$0, int $$1) {
            this.result.add(new Weighted<E>($$0, $$1));
            return this;
        }

        public WeightedList<E> build() {
            return new WeightedList(this.result.build());
        }
    }
}

