/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.thread;

import com.daqem.grieflogger.thread.OnComplete;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class ThreadManager {
    private static final ExecutorService executor = Executors.newWorkStealingPool();
    private static final Map<Future<?>, OnComplete<?>> onCompleteMap = new HashMap();

    public static void execute(Runnable runnable) {
        executor.execute(runnable);
    }

    public static <T> void submit(Callable<T> task, OnComplete<T> onComplete) {
        Future<T> future = executor.submit(task);
        onCompleteMap.put(future, onComplete);
    }

    public static <T> Map<Future<T>, OnComplete<T>> getAndRemoveCompleted() {
        Map<Future<T>, OnComplete<T>> completedFutures = onCompleteMap.entrySet().stream().filter(entry -> ((Future)entry.getKey()).isDone()).collect(Collectors.toMap(entry -> (Future)entry.getKey(), entry -> (OnComplete)entry.getValue()));
        completedFutures.forEach(onCompleteMap::remove);
        return completedFutures;
    }
}

