/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.event.block;

import com.daqem.grieflogger.database.service.Services;
import com.daqem.grieflogger.event.AbstractEvent;
import com.daqem.grieflogger.model.history.IHistory;
import com.daqem.grieflogger.player.GriefLoggerServerPlayer;
import com.daqem.grieflogger.thread.ThreadManager;
import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public class InspectContainerEvent
extends AbstractEvent {
    public static EventResult inspectContainer(GriefLoggerServerPlayer serverPlayer, Level level, BlockPos pos) {
        ThreadManager.submit(() -> {
            ArrayList<IHistory> history = new ArrayList<IHistory>();
            List<IHistory> containerHistory = Services.CONTAINER.getHistory(level, pos);
            List<IHistory> interactionHistory = Services.BLOCK.getInteractionHistory(level, pos);
            history.addAll(containerHistory);
            history.addAll(interactionHistory);
            history.sort((a, b) -> Long.compare(b.getTime().time(), a.getTime().time()));
            return history;
        }, serverPlayer::grieflogger$sendInspectMessage);
        return InspectContainerEvent.interrupt();
    }

    public static EventResult inspectContainers(GriefLoggerServerPlayer serverPlayer, Level level, BlockPos pos, BlockPos connectionPos) {
        ThreadManager.submit(() -> {
            ArrayList<IHistory> history = new ArrayList<IHistory>();
            List<IHistory> containerHistory = Services.CONTAINER.getHistory(level, pos, connectionPos);
            List<IHistory> interactionHistory = Services.BLOCK.getInteractionHistory(level, List.of(pos, connectionPos));
            history.addAll(containerHistory);
            history.addAll(interactionHistory);
            history.sort((a, b) -> Long.compare(b.getTime().time(), a.getTime().time()));
            return history;
        }, serverPlayer::grieflogger$sendInspectMessage);
        return InspectContainerEvent.interrupt();
    }
}

