/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.database.service;

import com.daqem.grieflogger.command.filter.FilterList;
import com.daqem.grieflogger.database.Database;
import com.daqem.grieflogger.database.repository.SessionRepository;
import com.daqem.grieflogger.model.action.SessionAction;
import com.daqem.grieflogger.model.history.SessionHistory;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public class SessionService {
    private final SessionRepository sessionRepository;

    public SessionService(Database database) {
        this.sessionRepository = new SessionRepository(database);
    }

    public void createTable() {
        this.sessionRepository.createTable();
    }

    public void createIndexes() {
        this.sessionRepository.createIndexes();
    }

    public void insert(UUID userUuid, Level level, BlockPos pos, SessionAction sessionAction) {
        this.sessionRepository.insert(System.currentTimeMillis(), userUuid.toString(), level.dimension().location().toString(), pos.getX(), pos.getY(), pos.getZ(), sessionAction.getId());
    }

    public List<SessionHistory> getFilteredSessionHistory(Level level, FilterList filterList) {
        return this.sessionRepository.getFilteredSessionHistory(level.dimension().location().toString(), filterList);
    }
}

