/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.database.repository;

import com.daqem.grieflogger.GriefLogger;
import com.daqem.grieflogger.command.filter.FilterList;
import com.daqem.grieflogger.database.Database;
import com.daqem.grieflogger.database.repository.Repository;
import com.daqem.grieflogger.model.history.SessionHistory;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SessionRepository
extends Repository {
    private final Database database;

    public SessionRepository(Database database) {
        this.database = database;
    }

    @Override
    public void createTable() {
        String sql = "CREATE TABLE IF NOT EXISTS sessions (\n    time integer NOT NULL,\n    user integer NOT NULL,\n    level integer NOT NULL,\n    x integer NOT NULL,\n    y integer NOT NULL,\n    z integer NOT NULL,\n    action integer NOT NULL,\n    FOREIGN KEY(user) REFERENCES users(id),\n    FOREIGN KEY(level) REFERENCES levels(id)\n);\n";
        if (this.isMysql()) {
            sql = "CREATE TABLE IF NOT EXISTS sessions (\n    time bigint NOT NULL,\n    user int NOT NULL,\n    level int NOT NULL,\n    x int NOT NULL,\n    y int NOT NULL,\n    z int NOT NULL,\n    action int NOT NULL,\n    FOREIGN KEY(user) REFERENCES users(id),\n    FOREIGN KEY(level) REFERENCES levels(id)\n)\nENGINE=InnoDB DEFAULT CHARACTER SET utf8mb4;\n";
        }
        this.database.createTable(sql);
    }

    public void createIndexes() {
        String sql = "CREATE INDEX IF NOT EXISTS coordinates ON sessions (x, y, z);\n";
        if (this.isMysql()) {
            sql = "ALTER TABLE sessions ADD INDEX coordinates (x, y, z);\n";
        }
        this.database.execute(sql, false);
    }

    public void insert(long time, String userUuid, String levelName, int x, int y, int z, int sessionAction) {
        String query = "INSERT OR IGNORE INTO sessions(time, user, level, x, y, z, action)\nVALUES(?, (\n    SELECT id FROM users WHERE uuid = ?\n), (\n    SELECT id FROM levels WHERE name = ?\n), ?, ?, ?, ?);\n";
        if (this.isMysql()) {
            query = "INSERT IGNORE INTO sessions(time, user, level, x, y, z, action)\nVALUES(?, (\n    SELECT id FROM users WHERE uuid = ?\n), (\n    SELECT id FROM levels WHERE name = ?\n), ?, ?, ?, ?);\n";
        }
        try {
            PreparedStatement preparedStatement = this.database.prepareStatement(query);
            preparedStatement.setLong(1, time);
            preparedStatement.setString(2, userUuid);
            preparedStatement.setString(3, levelName);
            preparedStatement.setInt(4, x);
            preparedStatement.setInt(5, y);
            preparedStatement.setInt(6, z);
            preparedStatement.setInt(7, sessionAction);
            this.database.queue.add(preparedStatement);
        }
        catch (SQLException exception) {
            GriefLogger.LOGGER.error("Failed to insert session into database", (Throwable)exception);
        }
    }

    public List<SessionHistory> getFilteredSessionHistory(String levelName, FilterList filterList) {
        ArrayList<SessionHistory> arrayList;
        block13: {
            @Nullable String actions = filterList.getActionString();
            @Nullable String users = filterList.getUserString();
            String query = "SELECT sessions.time, users.name, users.uuid, sessions.x, sessions.y, sessions.z, sessions.action\nFROM sessions\nINNER JOIN users ON sessions.user = users.id\nINNER JOIN levels ON sessions.level = levels.id\nWHERE levels.name = ?\nAND sessions.time > ?\nAND (? IS NULL OR sessions.action IN (%s))\nAND (? IS NULL OR users.id IN (%s))\nAND sessions.x BETWEEN ? AND ?\nAND sessions.y BETWEEN ? AND ?\nAND sessions.z BETWEEN ? AND ?\nORDER BY sessions.time DESC\nLIMIT 1000;\n".formatted(actions, users);
            PreparedStatement preparedStatement = this.database.prepareStatement(query);
            try {
                preparedStatement.setString(1, levelName);
                preparedStatement.setLong(2, filterList.getTime());
                if (actions == null || actions.isEmpty()) {
                    preparedStatement.setNull(3, 12);
                } else {
                    preparedStatement.setString(3, actions);
                }
                if (users == null || users.isEmpty()) {
                    preparedStatement.setNull(4, 12);
                } else {
                    preparedStatement.setString(4, users);
                }
                preparedStatement.setInt(5, filterList.getRadiusMinX());
                preparedStatement.setInt(6, filterList.getRadiusMaxX());
                preparedStatement.setInt(7, filterList.getRadiusMinY());
                preparedStatement.setInt(8, filterList.getRadiusMaxY());
                preparedStatement.setInt(9, filterList.getRadiusMinZ());
                preparedStatement.setInt(10, filterList.getRadiusMaxZ());
                ArrayList<SessionHistory> sessionHistory = new ArrayList<SessionHistory>();
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    sessionHistory.add(new SessionHistory(resultSet.getLong("time"), resultSet.getString("name"), resultSet.getString("uuid"), resultSet.getInt("x"), resultSet.getInt("y"), resultSet.getInt("z"), resultSet.getInt("action")));
                }
                arrayList = sessionHistory;
                if (preparedStatement == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException exception) {
                    GriefLogger.LOGGER.error("Failed to get session history from database", (Throwable)exception);
                    return List.of();
                }
            }
            preparedStatement.close();
        }
        return arrayList;
    }
}

