/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.database.repository;

import com.daqem.grieflogger.GriefLogger;
import com.daqem.grieflogger.database.Database;
import com.daqem.grieflogger.database.repository.Repository;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class LevelRepository
extends Repository {
    private final Database database;

    public LevelRepository(Database database) {
        this.database = database;
    }

    @Override
    public void createTable() {
        String sql = "CREATE TABLE IF NOT EXISTS levels (\n\tid integer PRIMARY KEY,\n\tname text NOT NULL UNIQUE\n);\n";
        if (this.isMysql()) {
            sql = "CREATE TABLE IF NOT EXISTS levels (\n\tid int PRIMARY KEY AUTO_INCREMENT,\n\tname varchar(256) NOT NULL UNIQUE\n)\nENGINE=InnoDB DEFAULT CHARACTER SET utf8mb4;\n";
        }
        this.database.createTable(sql);
    }

    public void insert(String name) {
        String query = "INSERT OR IGNORE INTO levels(name)\nVALUES(?);\n";
        if (this.isMysql()) {
            query = "INSERT IGNORE INTO levels(name)\nVALUES(?);\n";
        }
        try {
            PreparedStatement preparedStatement = this.database.prepareStatement(query);
            preparedStatement.setString(1, name);
            this.database.queue.add(preparedStatement);
        }
        catch (SQLException exception) {
            GriefLogger.LOGGER.error("Failed to insert level into database", (Throwable)exception);
        }
    }
}

