/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.database.repository;

import com.daqem.grieflogger.GriefLogger;
import com.daqem.grieflogger.command.filter.FilterList;
import com.daqem.grieflogger.database.Database;
import com.daqem.grieflogger.database.repository.Repository;
import com.daqem.grieflogger.model.SimpleItemStack;
import com.daqem.grieflogger.model.action.ItemAction;
import com.daqem.grieflogger.model.history.ItemHistory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemRepository
extends Repository {
    private final Database database;

    public ItemRepository(Database database) {
        this.database = database;
    }

    @Override
    public void createTable() {
        String sql = "CREATE TABLE IF NOT EXISTS items (\n    time integer NOT NULL,\n    user integer NOT NULL,\n    level integer NOT NULL,\n    x integer NOT NULL,\n    y integer NOT NULL,\n    z integer NOT NULL,\n    type integer NOT NULL,\n    data blob DEFAULT NULL,\n    amount integer NOT NULL,\n    action integer NOT NULL,\n    FOREIGN KEY(user) REFERENCES users(id),\n    FOREIGN KEY(level) REFERENCES levels(id),\n    FOREIGN KEY(type) REFERENCES materials(id)\n);\n";
        if (this.isMysql()) {
            sql = "CREATE TABLE IF NOT EXISTS items (\n    time bigint NOT NULL,\n    user int NOT NULL,\n    level int NOT NULL,\n    x int NOT NULL,\n    y int NOT NULL,\n    z int NOT NULL,\n    type int NOT NULL,\n    data blob DEFAULT NULL,\n    amount int NOT NULL,\n    action int NOT NULL,\n    FOREIGN KEY(user) REFERENCES users(id),\n    FOREIGN KEY(level) REFERENCES levels(id),\n    FOREIGN KEY(type) REFERENCES materials(id)\n)\nENGINE=InnoDB DEFAULT CHARACTER SET utf8mb4;\n";
        }
        this.database.createTable(sql);
    }

    public void createIndexes() {
        String sql = "CREATE INDEX IF NOT EXISTS coordinates ON items (x, y, z);\n";
        if (this.isMysql()) {
            sql = "ALTER TABLE items ADD INDEX coordinates (x, y, z);\n";
        }
        this.database.execute(sql, false);
    }

    public void insert(long time, String userUuid, Level level, int x, int y, int z, SimpleItemStack item, int action) {
        if (item.isEmpty()) {
            return;
        }
        String materialQuery = "INSERT OR IGNORE INTO materials(name)\nVALUES(?);\n";
        if (this.isMysql()) {
            materialQuery = "INSERT IGNORE INTO materials(name)\nVALUES(?);\n";
        }
        String itemQuery = "INSERT INTO items(time, user, level, x, y, z, type, data, amount, action)\nVALUES(?, (\n    SELECT id FROM users WHERE uuid = ?\n), (\n    SELECT id FROM levels WHERE name = ?\n), ?, ?, ?, (\n    SELECT id FROM materials WHERE name = ?\n), ?, ?, ?);\n";
        ResourceLocation itemLocation = item.getItem().arch$registryName();
        if (itemLocation != null) {
            try {
                PreparedStatement preparedStatement = this.database.prepareStatement(itemQuery);
                PreparedStatement materialStatement = this.database.prepareStatement(materialQuery);
                materialStatement.setString(1, itemLocation.toString().replace("minecraft:", ""));
                this.database.queue.add(materialStatement);
                preparedStatement.setLong(1, time);
                preparedStatement.setString(2, userUuid);
                preparedStatement.setString(3, level.dimension().location().toString());
                preparedStatement.setInt(4, x);
                preparedStatement.setInt(5, y);
                preparedStatement.setInt(6, z);
                preparedStatement.setString(7, itemLocation.toString().replace("minecraft:", ""));
                preparedStatement.setBytes(8, item.getTagBytes(level));
                preparedStatement.setInt(9, item.getCount());
                preparedStatement.setInt(10, action);
                this.database.queue.add(preparedStatement);
            }
            catch (SQLException exception) {
                GriefLogger.LOGGER.error("Failed to insert item into database", (Throwable)exception);
            }
        }
    }

    public void insertMap(long time, String userUuid, Level level, int x, int y, int z, Map<ItemAction, List<SimpleItemStack>> itemsMap) {
        String insertMaterialQuery = "INSERT OR IGNORE INTO materials(name)\nVALUES(?);\n";
        if (this.isMysql()) {
            insertMaterialQuery = "INSERT IGNORE INTO materials(name)\nVALUES(?);\n";
        }
        String insertItemQuery = "INSERT INTO items(time, user, level, x, y, z, type, data, amount, action)\nVALUES(?, (\n    SELECT id FROM users WHERE uuid = ?\n), (\n    SELECT id FROM levels WHERE name = ?\n), ?, ?, ?, (\n    SELECT id FROM materials WHERE name = ?\n), ?, ?, ?);\n";
        try {
            PreparedStatement itemStatement = this.database.prepareStatement(insertItemQuery);
            PreparedStatement materialStatement = this.database.prepareStatement(insertMaterialQuery);
            for (Map.Entry<ItemAction, List<SimpleItemStack>> entry : itemsMap.entrySet()) {
                for (SimpleItemStack item : entry.getValue()) {
                    ResourceLocation itemLocation;
                    if (item.isEmpty() || (itemLocation = item.getItem().arch$registryName()) == null) continue;
                    materialStatement.setString(1, itemLocation.toString().replace("minecraft:", ""));
                    materialStatement.addBatch();
                    itemStatement.setLong(1, time);
                    itemStatement.setString(2, userUuid);
                    itemStatement.setString(3, level.dimension().location().toString());
                    itemStatement.setInt(4, x);
                    itemStatement.setInt(5, y);
                    itemStatement.setInt(6, z);
                    itemStatement.setString(7, itemLocation.toString().replace("minecraft:", ""));
                    itemStatement.setBytes(8, item.getTagBytes(level));
                    itemStatement.setInt(9, item.getCount());
                    itemStatement.setInt(10, entry.getKey().getId());
                    itemStatement.addBatch();
                }
            }
            this.database.batchQueue.add(materialStatement);
            this.database.batchQueue.add(itemStatement);
        }
        catch (SQLException e) {
            GriefLogger.LOGGER.error("Failed to insert item", (Throwable)e);
        }
    }

    public List<ItemHistory> getFilteredItemHistory(Level level, FilterList filterList) {
        ArrayList<ItemHistory> arrayList;
        block17: {
            @Nullable String actions = filterList.getActionString();
            @Nullable String users = filterList.getUserString();
            @Nullable String includeMaterials = filterList.getIncludeMaterialsString();
            @Nullable String excludeMaterials = filterList.getExcludeMaterialsString();
            String query = "SELECT items.time, users.name, users.uuid, items.x, items.y, items.z, materials.name, items.data, items.amount, items.action\nFROM items\nINNER JOIN users ON items.user = users.id\nINNER JOIN levels ON items.level = levels.id\nINNER JOIN materials ON items.type = materials.id\nWHERE levels.name = ?\nAND items.time > ?\nAND (? IS NULL OR items.action IN (%s))\nAND (? IS NULL OR users.id IN (%s))\nAND (? IS NULL OR materials.name IN ('%s'))\nAND (? IS NULL OR materials.name NOT IN ('%s'))\nAND items.x BETWEEN ? AND ?\nAND items.y BETWEEN ? AND ?\nAND items.z BETWEEN ? AND ?\nORDER BY items.time DESC\nLIMIT 1000;\n".formatted(actions, users, includeMaterials, excludeMaterials);
            PreparedStatement preparedStatement = this.database.prepareStatement(query);
            try {
                preparedStatement.setString(1, level.dimension().location().toString());
                preparedStatement.setLong(2, filterList.getTime());
                if (actions == null || actions.isEmpty()) {
                    preparedStatement.setNull(3, 12);
                } else {
                    preparedStatement.setString(3, "not null");
                }
                if (users == null || users.isEmpty()) {
                    preparedStatement.setNull(4, 12);
                } else {
                    preparedStatement.setString(4, "not null");
                }
                if (includeMaterials == null || includeMaterials.isEmpty()) {
                    preparedStatement.setNull(5, 12);
                } else {
                    preparedStatement.setString(5, "not null");
                }
                if (excludeMaterials == null || excludeMaterials.isEmpty()) {
                    preparedStatement.setNull(6, 12);
                } else {
                    preparedStatement.setString(6, "not null");
                }
                preparedStatement.setInt(7, filterList.getRadiusMinX());
                preparedStatement.setInt(8, filterList.getRadiusMaxX());
                preparedStatement.setInt(9, filterList.getRadiusMinY());
                preparedStatement.setInt(10, filterList.getRadiusMaxY());
                preparedStatement.setInt(11, filterList.getRadiusMinZ());
                preparedStatement.setInt(12, filterList.getRadiusMaxZ());
                ArrayList<ItemHistory> itemHistory = new ArrayList<ItemHistory>();
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    ByteBuf buf1 = Unpooled.wrappedBuffer((byte[])resultSet.getBytes(8));
                    RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(buf1, level.registryAccess());
                    DataComponentPatch patch = (DataComponentPatch)DataComponentPatch.STREAM_CODEC.decode((Object)buf);
                    itemHistory.add(new ItemHistory(resultSet.getLong(1), resultSet.getString(2), resultSet.getString(3), resultSet.getInt(4), resultSet.getInt(5), resultSet.getInt(6), resultSet.getString(7), patch, resultSet.getInt(9), resultSet.getInt(10)));
                }
                arrayList = itemHistory;
                if (preparedStatement == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException exception) {
                    GriefLogger.LOGGER.error("Failed to get block history from database", (Throwable)exception);
                    return List.of();
                }
            }
            preparedStatement.close();
        }
        return arrayList;
    }
}

