/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.database.repository;

import com.daqem.grieflogger.GriefLogger;
import com.daqem.grieflogger.database.Database;
import com.daqem.grieflogger.database.repository.Repository;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class CommandRepository
extends Repository {
    private final Database database;

    public CommandRepository(Database database) {
        this.database = database;
    }

    @Override
    public void createTable() {
        String sql = "CREATE TABLE IF NOT EXISTS commands (\n    time integer NOT NULL,\n    user integer NOT NULL,\n    level integer NOT NULL,\n    x integer NOT NULL,\n    y integer NOT NULL,\n    z integer NOT NULL,\n    command text NOT NULL,\n    FOREIGN KEY(user) REFERENCES users(id),\n    FOREIGN KEY(level) REFERENCES levels(id)\n);\n";
        if (this.isMysql()) {
            sql = "CREATE TABLE IF NOT EXISTS commands (\n    time bigint NOT NULL,\n    user int NOT NULL,\n    level int NOT NULL,\n    x int NOT NULL,\n    y int NOT NULL,\n    z int NOT NULL,\n    command varchar(256) NOT NULL,\n    FOREIGN KEY(user) REFERENCES users(id),\n    FOREIGN KEY(level) REFERENCES levels(id)\n)\nENGINE=InnoDB DEFAULT CHARACTER SET utf8mb4;\n";
        }
        this.database.createTable(sql);
    }

    public void createIndexes() {
        String sql = "CREATE INDEX IF NOT EXISTS coordinates ON commands (x, y, z);\n";
        if (this.isMysql()) {
            sql = "ALTER TABLE commands ADD INDEX coordinates (x, y, z);\n";
        }
        this.database.execute(sql, false);
    }

    public void insert(long time, String userUuid, String levelName, int x, int y, int z, String command) {
        String query = "INSERT OR IGNORE INTO commands(time, user, level, x, y, z, command)\nVALUES(?, (\n    SELECT id FROM users WHERE uuid = ?\n), (\n    SELECT id FROM levels WHERE name = ?\n), ?, ?, ?, ?);\n";
        if (this.isMysql()) {
            query = "INSERT IGNORE INTO commands(time, user, level, x, y, z, command)\nVALUES(?, (\n    SELECT id FROM users WHERE uuid = ?\n), (\n    SELECT id FROM levels WHERE name = ?\n), ?, ?, ?, ?);\n";
        }
        try {
            PreparedStatement preparedStatement = this.database.prepareStatement(query);
            preparedStatement.setLong(1, time);
            preparedStatement.setString(2, userUuid);
            preparedStatement.setString(3, levelName);
            preparedStatement.setInt(4, x);
            preparedStatement.setInt(5, y);
            preparedStatement.setInt(6, z);
            preparedStatement.setString(7, command);
            this.database.queue.add(preparedStatement);
        }
        catch (SQLException exception) {
            GriefLogger.LOGGER.error("Failed to insert command into database", (Throwable)exception);
        }
    }
}

