/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.command.page;

import com.daqem.grieflogger.GriefLogger;
import com.daqem.grieflogger.model.history.IHistory;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;

public class Page {
    public static final int MAX_PAGE_SIZE = 10;
    private final List<IHistory> history;
    private final int page;
    private final int maxPage;
    private final boolean singleLocation;

    public Page(List<IHistory> history, int page, int maxPage, boolean singleLocation) {
        this.history = history;
        this.page = page;
        this.maxPage = maxPage;
        this.singleLocation = singleLocation;
    }

    public List<Component> getHistory() {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(this.getHeader());
        for (IHistory history : this.history) {
            if (this.singleLocation) {
                components.add(history.getComponent());
                continue;
            }
            components.add(history.getComponentWithPos());
        }
        if (this.maxPage > 1) {
            components.add(this.getFooter());
        }
        return components;
    }

    private Component getHeader() {
        MutableComponent header = GriefLogger.translate("lookup.history_header", GriefLogger.themedTranslate("lookup.history_title"));
        if (this.singleLocation && !this.history.isEmpty()) {
            header.append(" ").append(this.history.get(0).getPosition().getComponent());
        }
        return header;
    }

    private Component getFooter() {
        return this.getArrowLeft().append(" ").append((Component)GriefLogger.themedTranslate("lookup.page")).append(" ").append((Component)GriefLogger.translate("lookup.pages", this.page, this.maxPage).withStyle(ChatFormatting.WHITE)).append(" ").append((Component)this.getArrowRight());
    }

    private MutableComponent getArrowLeft() {
        return GriefLogger.literal("\u2bc7").withStyle(this.getStyle(this.page - 1, this.page > 1));
    }

    private MutableComponent getArrowRight() {
        return GriefLogger.literal("\u2bc8").withStyle(this.getStyle(this.page + 1, this.page < this.maxPage));
    }

    private ClickEvent getClickEvent(int page) {
        return new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/grieflogger page " + page);
    }

    private Style getStyle(int page, boolean enabled) {
        Style style = Style.EMPTY.withClickEvent(this.getClickEvent(page)).withColor(ChatFormatting.WHITE);
        if (!enabled) {
            style = Style.EMPTY.withColor(ChatFormatting.GRAY);
        }
        return style;
    }

    public void sendToPlayer(ServerPlayer serverPlayer) {
        this.getHistory().forEach(arg_0 -> ((ServerPlayer)serverPlayer).sendSystemMessage(arg_0));
    }

    public static List<Page> convertToPages(List<IHistory> history, boolean singleLocation) {
        ArrayList<Page> pages = new ArrayList<Page>();
        int maxPage = (int)Math.ceil((double)history.size() / 10.0);
        int page = 1;
        for (int i = 0; i < history.size(); i += 10) {
            int finalPage = page++;
            pages.add(history.subList(i, Math.min(i + 10, history.size())).stream().collect(Collectors.collectingAndThen(Collectors.toList(), x -> new Page((List<IHistory>)x, finalPage, maxPage, singleLocation))));
        }
        return pages;
    }
}

