/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.grieflogger.command.filter;

import com.daqem.grieflogger.GriefLogger;
import com.daqem.grieflogger.command.filter.IFilter;
import com.daqem.grieflogger.model.action.Actions;
import com.daqem.grieflogger.model.action.IAction;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ActionFilter
implements IFilter {
    private final List<IAction> actions;

    public ActionFilter() {
        this(new ArrayList<IAction>());
    }

    public ActionFilter(List<IAction> actions) {
        this.actions = actions;
    }

    @Override
    public String getName() {
        return GriefLogger.translate("filter.action").getString();
    }

    @Override
    public List<String> getOptions() {
        return Arrays.asList((String[])Actions.ACTIONS.stream().map(IAction::name).map(String::toLowerCase).toArray(String[]::new));
    }

    @Override
    public IFilter parse(StringReader reader, String suffix) throws CommandSyntaxException {
        ArrayList<IAction> actions;
        String[] split = suffix.split(",");
        if (split.length != (actions = new ArrayList<IAction>(Actions.getActions(split))).size()) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext((ImmutableStringReader)reader);
        }
        return new ActionFilter(actions);
    }

    public String toString() {
        return "ActionFilter{actions=" + String.valueOf(this.actions) + "}";
    }

    public List<IAction> getActions() {
        return this.actions;
    }
}

