/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.mixin.entity;

import mod.crend.dynamiccrosshair.mixin.entity.AnimalEntityMixin;
import mod.crend.dynamiccrosshairapi.crosshair.CrosshairContext;
import mod.crend.dynamiccrosshairapi.interaction.InteractionType;
import mod.crend.dynamiccrosshairapi.type.DynamicCrosshairEntity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={AbstractHorse.class})
public abstract class AbstractHorseEntityMixin
extends AnimalEntityMixin
implements DynamicCrosshairEntity {
    @Shadow
    public abstract boolean isTamed();

    @Shadow
    public abstract boolean isSaddleable();

    @Shadow
    public abstract boolean isSaddled();

    @Override
    public InteractionType dynamiccrosshair$compute(CrosshairContext context) {
        if (!this.isVehicle() && !this.isBaby()) {
            if (this.isTamed() && context.getPlayer().isSecondaryUseActive()) {
                return InteractionType.INTERACT_WITH_ENTITY;
            }
            ItemStack itemStack = context.getItemStack();
            if (!itemStack.isEmpty()) {
                if (this.isSaddleable() && !this.isSaddled() && itemStack.is(Items.SADDLE)) {
                    return InteractionType.PLACE_ITEM_ON_ENTITY;
                }
                if (this.canUseSlot(EquipmentSlot.BODY) && this.isBodyArmorItem(itemStack) && !this.isWearingBodyArmor()) {
                    return InteractionType.PLACE_ITEM_ON_ENTITY;
                }
            }
            return InteractionType.MOUNT_ENTITY;
        }
        return super.dynamiccrosshair$compute(context);
    }
}

