/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.portable_energy_interface;

import com.mrh0.createaddition.blocks.portable_energy_interface.PEIActorVisual;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceBlock;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceBlockEntity;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceRenderer;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorVisual;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import java.util.Optional;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class PortableEnergyInterfaceMovement
implements MovementBehaviour {
    static final String _workingPos_ = "WorkingPos";
    static final String _clientPrevPos_ = "ClientPrevPos";

    public Vec3 getActiveAreaOffset(MovementContext context) {
        return Vec3.atLowerCornerOf((Vec3i)((Direction)context.state.getValue((Property)PortableEnergyInterfaceBlock.FACING)).getNormal()).scale((double)1.85f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        if (!VisualizationManager.supportsVisualization((LevelAccessor)context.world)) {
            PortableEnergyInterfaceRenderer.renderInContraption(context, renderWorld, matrices, buffer);
        }
    }

    @Nullable
    public ActorVisual createVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        return new PEIActorVisual(visualizationContext, simulationWorld, movementContext);
    }

    public void visitNewPosition(MovementContext context, BlockPos pos) {
        boolean onCarriage = context.contraption instanceof CarriageContraption;
        if (!(onCarriage && context.motion.length() > 0.25 || this.findInterface(context, pos))) {
            context.data.remove(_workingPos_);
        }
    }

    public void tick(MovementContext context) {
        boolean onCarriage;
        if (context.world.isClientSide) {
            PortableEnergyInterfaceMovement.getAnimation(context).tickChaser();
        }
        if (!(onCarriage = context.contraption instanceof CarriageContraption) || !(context.motion.length() > 0.25)) {
            if (context.world.isClientSide) {
                BlockPos pos = BlockPos.containing((Position)context.position);
                if (!this.findInterface(context, pos)) {
                    this.reset(context);
                }
            } else if (context.data.contains(_workingPos_)) {
                Optional<Direction> currentFacingIfValid;
                BlockPos pos = NbtUtils.readBlockPos((CompoundTag)context.data, (String)_workingPos_).orElse(BlockPos.ZERO);
                Vec3 target = VecHelper.getCenterOf((Vec3i)pos);
                if (!context.stall && !onCarriage && context.position.closerThan((Position)target, target.distanceTo(context.position.add(context.motion)))) {
                    context.stall = true;
                }
                if ((currentFacingIfValid = this.getCurrentFacingIfValid(context)).isPresent()) {
                    PortableEnergyInterfaceBlockEntity stationaryInterface = this.getStationaryInterfaceAt(context.world, pos, context.state, currentFacingIfValid.get());
                    if (stationaryInterface == null) {
                        this.reset(context);
                    } else {
                        if (stationaryInterface.getConnectedEntity() == null) {
                            stationaryInterface.startTransferringTo(context.contraption, stationaryInterface.getConnectionDistance());
                        }
                        boolean timerBelow = stationaryInterface.getTransferTimer() <= 4;
                        stationaryInterface.keepAlive = 2;
                        if (context.stall && timerBelow) {
                            context.stall = false;
                        }
                    }
                }
            }
        }
    }

    protected boolean findInterface(MovementContext context, BlockPos pos) {
        CarriageContraption cc;
        Contraption var4 = context.contraption;
        if (var4 instanceof CarriageContraption && !(cc = (CarriageContraption)var4).notInPortal()) {
            return false;
        }
        Optional<Direction> currentFacingIfValid = this.getCurrentFacingIfValid(context);
        if (currentFacingIfValid.isEmpty()) {
            return false;
        }
        Direction currentFacing = currentFacingIfValid.get();
        PortableEnergyInterfaceBlockEntity psi = this.findStationaryInterface(context.world, pos, context.state, currentFacing);
        if (psi == null) {
            return false;
        }
        if (psi.isPowered()) {
            return false;
        }
        context.data.put(_workingPos_, NbtUtils.writeBlockPos((BlockPos)psi.getBlockPos()));
        if (!context.world.isClientSide) {
            Vec3 diff = VecHelper.getCenterOf((Vec3i)psi.getBlockPos()).subtract(context.position);
            diff = VecHelper.project((Vec3)diff, (Vec3)Vec3.atLowerCornerOf((Vec3i)currentFacing.getNormal()));
            float distance = (float)(diff.length() + (double)1.85f - 1.0);
            psi.startTransferringTo(context.contraption, distance);
        } else {
            context.data.put(_clientPrevPos_, NbtUtils.writeBlockPos((BlockPos)pos));
            if (context.contraption instanceof CarriageContraption || context.contraption.entity.isStalled() || context.motion.lengthSqr() == 0.0) {
                PortableEnergyInterfaceMovement.getAnimation(context).chase((double)(psi.getConnectionDistance() / 2.0f), 0.25, LerpedFloat.Chaser.LINEAR);
            }
        }
        return true;
    }

    public void cancelStall(MovementContext context) {
        this.reset(context);
    }

    public void reset(MovementContext context) {
        context.data.remove(_clientPrevPos_);
        context.data.remove(_workingPos_);
        context.stall = false;
        PortableEnergyInterfaceMovement.getAnimation(context).chase(0.0, 0.25, LerpedFloat.Chaser.LINEAR);
    }

    @Nullable
    private PortableEnergyInterfaceBlockEntity findStationaryInterface(Level world, BlockPos pos, BlockState state, Direction facing) {
        for (int i = 0; i < 2; ++i) {
            PortableEnergyInterfaceBlockEntity interfaceAt = this.getStationaryInterfaceAt(world, pos.relative(facing, i), state, facing);
            if (interfaceAt == null) continue;
            return interfaceAt;
        }
        return null;
    }

    @Nullable
    private PortableEnergyInterfaceBlockEntity getStationaryInterfaceAt(Level world, BlockPos pos, BlockState state, Direction facing) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof PortableEnergyInterfaceBlockEntity) {
            PortableEnergyInterfaceBlockEntity psi = (PortableEnergyInterfaceBlockEntity)te;
            BlockState blockState = world.getBlockState(pos);
            if (blockState.getBlock() != state.getBlock()) {
                return null;
            }
            if (blockState.getValue((Property)PortableEnergyInterfaceBlock.FACING) != facing.getOpposite()) {
                return null;
            }
            return psi.isPowered() ? null : psi;
        }
        return null;
    }

    private Optional<Direction> getCurrentFacingIfValid(MovementContext context) {
        Direction facingFromVector;
        Vec3 directionVec = Vec3.atLowerCornerOf((Vec3i)((Direction)context.state.getValue((Property)PortableEnergyInterfaceBlock.FACING)).getNormal());
        return (directionVec = (Vec3)context.rotation.apply(directionVec)).distanceTo(Vec3.atLowerCornerOf((Vec3i)(facingFromVector = Direction.getNearest((double)directionVec.x, (double)directionVec.y, (double)directionVec.z)).getNormal())) > 0.5 ? Optional.empty() : Optional.of(facingFromVector);
    }

    public static LerpedFloat getAnimation(MovementContext context) {
        Object var2 = context.temporaryData;
        if (var2 instanceof LerpedFloat) {
            LerpedFloat lf = (LerpedFloat)var2;
            return lf;
        }
        LerpedFloat nlf = LerpedFloat.linear();
        context.temporaryData = nlf;
        return nlf;
    }
}

