/*
 * Decompiled with CFR 0.152.
 */
package com.molybdenum.alloyed.common.util;

import com.molybdenum.alloyed.common.registry.ModBlocks;
import com.simibubi.create.content.decoration.encasing.EncasedBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class EncasingHelper {
    protected static Supplier<? extends EncasedBlock> getSteelEncasedVariant(EncaseType type) {
        if (type == EncaseType.SHAFT) {
            return ModBlocks.STEEL_ENCASED_SHAFT;
        }
        if (type == EncaseType.SMALL_COG) {
            return ModBlocks.STEEL_ENCASED_COGWHEEL;
        }
        if (type == EncaseType.LARGE_COG) {
            return ModBlocks.STEEL_ENCASED_LARGE_COGWHEEL;
        }
        throw new IllegalStateException("How did we get here?");
    }

    protected static Supplier<? extends EncasedBlock> getBronzeEncasedVariant(EncaseType type) {
        if (type == EncaseType.SHAFT) {
            return ModBlocks.BRONZE_ENCASED_SHAFT;
        }
        if (type == EncaseType.SMALL_COG) {
            return ModBlocks.BRONZE_ENCASED_COGWHEEL;
        }
        if (type == EncaseType.LARGE_COG) {
            return ModBlocks.BRONZE_ENCASED_LARGE_COGWHEEL;
        }
        throw new IllegalStateException("How did we get here?");
    }

    public static ItemInteractionResult tryEncase(EncaseType type, BlockState state, Level level, BlockPos pos, ItemStack heldItem, Player player, InteractionHand hand, BlockHitResult ray) {
        if (ModBlocks.STEEL_CASING.isIn(heldItem)) {
            return EncasingHelper.tryEncaseWithSteel(type, state, level, pos, heldItem, player, hand, ray);
        }
        if (ModBlocks.BRONZE_CASING.isIn(heldItem)) {
            return EncasingHelper.tryEncaseWithBronze(type, state, level, pos, heldItem, player, hand, ray);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static ItemInteractionResult tryEncaseWithSteel(EncaseType type, BlockState state, Level level, BlockPos pos, ItemStack heldItem, Player player, InteractionHand hand, BlockHitResult ray) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        EncasingHelper.getSteelEncasedVariant(type).get().handleEncasing(state, level, pos, heldItem, player, hand, ray);
        return ItemInteractionResult.SUCCESS;
    }

    public static ItemInteractionResult tryEncaseWithBronze(EncaseType type, BlockState state, Level level, BlockPos pos, ItemStack heldItem, Player player, InteractionHand hand, BlockHitResult ray) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        EncasingHelper.getBronzeEncasedVariant(type).get().handleEncasing(state, level, pos, heldItem, player, hand, ray);
        return ItemInteractionResult.SUCCESS;
    }

    public static enum EncaseType {
        SHAFT,
        SMALL_COG,
        LARGE_COG;


        public static EncaseType fromCogSize(boolean isLarge) {
            if (isLarge) {
                return LARGE_COG;
            }
            return SMALL_COG;
        }
    }
}

