/*
 * Decompiled with CFR 0.152.
 */
package com.molybdenum.alloyed.common.registry;

import com.molybdenum.alloyed.Alloyed;
import com.molybdenum.alloyed.common.compat.createdeco.connected.SteelSheetMetalCTBehaviour;
import com.molybdenum.alloyed.common.compat.createdeco.connected.SteelSheetSlabCTBehaviour;
import com.molybdenum.alloyed.common.content.blocks.AlloyedShaftBlock;
import com.molybdenum.alloyed.common.content.blocks.BronzeBellBlock;
import com.molybdenum.alloyed.common.content.blocks.SteelDoorBlock;
import com.molybdenum.alloyed.common.content.blocks.WeatheringBronzePillarBlock;
import com.molybdenum.alloyed.common.item.ModCreativeModeTab;
import com.molybdenum.alloyed.common.registry.ModBlockSetTypes;
import com.molybdenum.alloyed.common.registry.ModSpriteShifts;
import com.molybdenum.alloyed.common.registry.ModTags;
import com.molybdenum.alloyed.common.registry.ModTransformers;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.simibubi.create.content.contraptions.behaviour.DoorMovingInteraction;
import com.simibubi.create.content.decoration.MetalLadderBlock;
import com.simibubi.create.content.decoration.MetalScaffoldingBlock;
import com.simibubi.create.content.decoration.encasing.CasingBlock;
import com.simibubi.create.content.decoration.palettes.ConnectedPillarBlock;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogCTBehaviour;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogwheelBlock;
import com.simibubi.create.foundation.block.CopperBlockSet;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.RotatedPillarCTBehaviour;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.simibubi.create.foundation.data.BuilderTransformers;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Couple;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.WeatheringCopperFullBlock;
import net.minecraft.world.level.block.WeatheringCopperSlabBlock;
import net.minecraft.world.level.block.WeatheringCopperStairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.NotNull;

public class ModBlocks {
    private static final CreateRegistrate REGISTRATE = (CreateRegistrate)Alloyed.REGISTRATE.setCreativeTab(ModCreativeModeTab.MAIN_TAB).defaultCreativeTab((ResourceKey)null);
    public static final CopperBlockSet BRONZE_BLOCKS = new CopperBlockSet((AbstractRegistrate)REGISTRATE, "bronze_block", "bronze_block", new CopperBlockSet.Variant[]{CopperBlockSet.BlockVariant.INSTANCE}, "bronze/");
    public static final List<BlockEntry<? extends Block>> CUT_BRONZE = ModBlocks.registerCutBronzeSet("cut_bronze", WeatheringCopper.WeatherState.UNAFFECTED);
    public static final List<BlockEntry<? extends Block>> CUT_EXPOSED_BRONZE = ModBlocks.registerCutBronzeSet("cut_exposed_bronze", WeatheringCopper.WeatherState.EXPOSED);
    public static final List<BlockEntry<? extends Block>> CUT_WEATHERED_BRONZE = ModBlocks.registerCutBronzeSet("cut_weathered_bronze", WeatheringCopper.WeatherState.WEATHERED);
    public static final List<BlockEntry<? extends Block>> CUT_OXIDIZED_BRONZE = ModBlocks.registerCutBronzeSet("cut_oxidized_bronze", WeatheringCopper.WeatherState.OXIDIZED);
    public static final List<BlockEntry<? extends Block>> BRONZE_PILLAR = ModBlocks.registerBronzePillarSet("bronze_pillar", WeatheringCopper.WeatherState.UNAFFECTED, ModSpriteShifts.BRONZE_PILLAR, ModSpriteShifts.BRONZE_CAP);
    public static final List<BlockEntry<? extends Block>> EXPOSED_BRONZE_PILLAR = ModBlocks.registerBronzePillarSet("exposed_bronze_pillar", WeatheringCopper.WeatherState.EXPOSED, ModSpriteShifts.EXPOSED_BRONZE_PILLAR, ModSpriteShifts.EXPOSED_BRONZE_CAP);
    public static final List<BlockEntry<? extends Block>> WEATHERED_BRONZE_PILLAR = ModBlocks.registerBronzePillarSet("weathered_bronze_pillar", WeatheringCopper.WeatherState.WEATHERED, ModSpriteShifts.WEATHERED_BRONZE_PILLAR, ModSpriteShifts.WEATHERED_BRONZE_CAP);
    public static final List<BlockEntry<? extends Block>> OXIDIZED_BRONZE_PILLAR = ModBlocks.registerBronzePillarSet("oxidized_bronze_pillar", WeatheringCopper.WeatherState.OXIDIZED, ModSpriteShifts.OXIDIZED_BRONZE_PILLAR, ModSpriteShifts.OXIDIZED_BRONZE_CAP);
    public static final BlockEntry<CasingBlock> BRONZE_CASING = ((BlockBuilder)((BlockBuilder)REGISTRATE.block("bronze_casing", CasingBlock::new).transform((NonNullFunction)BuilderTransformers.casing(() -> ModSpriteShifts.BRONZE_CASING))).properties(ModBlocks::bronzeProperties).item().build()).register();
    public static final BlockEntry<AlloyedShaftBlock> BRONZE_ENCASED_SHAFT = ((BlockBuilder)((BlockBuilder)REGISTRATE.block("bronze_encased_shaft", p -> new AlloyedShaftBlock((BlockBehaviour.Properties)p, () -> BRONZE_CASING.get())).properties(ModBlocks::bronzeProperties).transform(ModTransformers.encasedShaft("bronze", () -> ModSpriteShifts.BRONZE_CASING))).transform(TagGen.axeOrPickaxe())).register();
    public static final BlockEntry<EncasedCogwheelBlock> BRONZE_ENCASED_COGWHEEL = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("bronze_encased_cogwheel", p -> new EncasedCogwheelBlock(p, false, () -> BRONZE_CASING.get())).properties(ModBlocks::bronzeProperties).transform(ModTransformers.encasedCogwheel("bronze", () -> ModSpriteShifts.BRONZE_CASING))).blockstate((c, p) -> BlockStateGen.axisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, blockState -> {
        String suffix = ((Boolean)blockState.getValue((Property)EncasedCogwheelBlock.TOP_SHAFT) != false ? "_top" : "") + ((Boolean)blockState.getValue((Property)EncasedCogwheelBlock.BOTTOM_SHAFT) != false ? "_bottom" : "");
        return p.models().getExistingFile(p.modLoc("block/bronze_encased_cogwheel/block" + suffix));
    }, (boolean)false)).item().model((c, p) -> p.getExistingFile(p.modLoc(c.getName()))).build()).onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCogCTBehaviour(ModSpriteShifts.BRONZE_CASING, Couple.create((Object)ModSpriteShifts.BRONZE_ENCASED_COGWHEEL_SIDE, (Object)ModSpriteShifts.BRONZE_ENCASED_COGWHEEL_OTHERSIDE))))).transform(TagGen.axeOrPickaxe())).register();
    public static final BlockEntry<EncasedCogwheelBlock> BRONZE_ENCASED_LARGE_COGWHEEL = ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("bronze_encased_large_cogwheel", p -> new EncasedCogwheelBlock(p, true, () -> BRONZE_CASING.get())).properties(ModBlocks::bronzeProperties).transform(ModTransformers.encasedLargeCogwheel("bronze", () -> ModSpriteShifts.BRONZE_CASING))).blockstate((c, p) -> BlockStateGen.axisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, blockState -> {
        String suffix = ((Boolean)blockState.getValue((Property)EncasedCogwheelBlock.TOP_SHAFT) != false ? "_top" : "") + ((Boolean)blockState.getValue((Property)EncasedCogwheelBlock.BOTTOM_SHAFT) != false ? "_bottom" : "");
        return p.models().getExistingFile(p.modLoc("block/bronze_encased_large_cogwheel/block" + suffix));
    }, (boolean)false)).item().model((c, p) -> p.getExistingFile(p.modLoc(c.getName()))).build()).transform(TagGen.axeOrPickaxe())).register();
    public static final BlockEntry<BronzeBellBlock> BRONZE_BELL = ((BlockBuilder)REGISTRATE.block("bronze_bell", BronzeBellBlock::new).initialProperties(() -> Blocks.IRON_BLOCK).properties(properties -> properties.noOcclusion().sound(SoundType.ANVIL)).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).tag(new TagKey[]{BlockTags.NEEDS_STONE_TOOL}).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)1).pattern("#").pattern("-").define(Character.valueOf('#'), ModTags.Items.BRONZE_BLOCK).define(Character.valueOf('-'), ModTags.Items.BRONZE_SHEET).unlockedBy("has_bronze_ingot", RegistrateRecipeProvider.has(ModTags.Items.BRONZE_INGOT)).save((RecipeOutput)prov, Alloyed.asResource("crafting/" + ctx.getName()))).item().build()).register();
    public static final BlockEntry<Block> STEEL_BLOCK = ((BlockBuilder)REGISTRATE.block("steel_block", Block::new).initialProperties(() -> Blocks.IRON_BLOCK).properties(ModBlocks::steelProperties).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).tag(new TagKey[]{BlockTags.NEEDS_STONE_TOOL}).lang("Block of Steel").item().build()).register();
    public static final BlockEntry<CasingBlock> STEEL_CASING = ((BlockBuilder)REGISTRATE.block("steel_casing", CasingBlock::new).transform((NonNullFunction)BuilderTransformers.casing(() -> ModSpriteShifts.STEEL_CASING))).properties(ModBlocks::steelProperties).register();
    public static final BlockEntry<AlloyedShaftBlock> STEEL_ENCASED_SHAFT = ((BlockBuilder)((BlockBuilder)REGISTRATE.block("steel_encased_shaft", p -> new AlloyedShaftBlock((BlockBehaviour.Properties)p, () -> STEEL_CASING.get())).properties(ModBlocks::steelProperties).transform(ModTransformers.encasedShaft("steel", () -> ModSpriteShifts.STEEL_CASING))).transform(TagGen.axeOrPickaxe())).register();
    public static final BlockEntry<EncasedCogwheelBlock> STEEL_ENCASED_COGWHEEL = ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("steel_encased_cogwheel", p -> new EncasedCogwheelBlock(p, false, () -> STEEL_CASING.get())).properties(ModBlocks::steelProperties).transform(ModTransformers.encasedCogwheel("steel", () -> ModSpriteShifts.STEEL_CASING))).blockstate((c, p) -> BlockStateGen.axisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, blockState -> {
        String suffix = ((Boolean)blockState.getValue((Property)EncasedCogwheelBlock.TOP_SHAFT) != false ? "_top" : "") + ((Boolean)blockState.getValue((Property)EncasedCogwheelBlock.BOTTOM_SHAFT) != false ? "_bottom" : "");
        return p.models().getExistingFile(p.modLoc("block/steel_encased_cogwheel/block" + suffix));
    }, (boolean)false)).onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCogCTBehaviour(ModSpriteShifts.STEEL_CASING, Couple.create((Object)ModSpriteShifts.STEEL_ENCASED_COGWHEEL_SIDE, (Object)ModSpriteShifts.STEEL_ENCASED_COGWHEEL_OTHERSIDE))))).transform(TagGen.axeOrPickaxe())).register();
    public static final BlockEntry<EncasedCogwheelBlock> STEEL_ENCASED_LARGE_COGWHEEL = ((BlockBuilder)((BlockBuilder)REGISTRATE.block("steel_encased_large_cogwheel", p -> new EncasedCogwheelBlock(p, true, () -> STEEL_CASING.get())).properties(ModBlocks::steelProperties).transform(ModTransformers.encasedLargeCogwheel("steel", () -> ModSpriteShifts.STEEL_CASING))).blockstate((c, p) -> BlockStateGen.axisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, blockState -> {
        String suffix = ((Boolean)blockState.getValue((Property)EncasedCogwheelBlock.TOP_SHAFT) != false ? "_top" : "") + ((Boolean)blockState.getValue((Property)EncasedCogwheelBlock.BOTTOM_SHAFT) != false ? "_bottom" : "");
        return p.models().getExistingFile(p.modLoc("block/steel_encased_large_cogwheel/block" + suffix));
    }, (boolean)false)).transform(TagGen.axeOrPickaxe())).register();
    public static final BlockEntry<MetalScaffoldingBlock> STEEL_SCAFFOLD = ((BlockBuilder)REGISTRATE.block("steel_scaffolding", MetalScaffoldingBlock::new).transform(ModTransformers.scaffold("steel", () -> DataIngredient.tag((TagKey)AllTags.commonItemTag((String)"ingots/steel")), MapColor.COLOR_GRAY, ModSpriteShifts.STEEL_SCAFFOLD, ModSpriteShifts.STEEL_SCAFFOLD_INSIDE, ModSpriteShifts.STEEL_CASING))).properties(ModBlocks::steelProperties).register();
    public static final BlockEntry<SteelDoorBlock> STEEL_DOOR = ((BlockBuilder)ModBlocks.steelDoorBlock(false, null).onRegister(MovingInteractionBehaviour.interactionBehaviour((MovingInteractionBehaviour)new DoorMovingInteraction()))).register();
    public static final BlockEntry<SteelDoorBlock> LOCKED_STEEL_DOOR = ModBlocks.steelDoorBlock(true, STEEL_DOOR).register();
    public static final BlockEntry<Block> STEEL_SHEET_METAL = ((BlockBuilder)REGISTRATE.block("steel_sheet_metal", Block::new).initialProperties(() -> Blocks.IRON_BLOCK).properties(ModBlocks::steelProperties).simpleItem().tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).tag(new TagKey[]{BlockTags.NEEDS_STONE_TOOL}).onRegister(CreateRegistrate.connectedTextures(SteelSheetMetalCTBehaviour::new))).register();
    public static final BlockEntry<StairBlock> STEEL_SHEET_STAIRS = ((BlockBuilder)((BlockBuilder)REGISTRATE.block("steel_sheet_stairs", properties -> new StairBlock(Blocks.BRICK_STAIRS.defaultBlockState(), properties)).initialProperties(() -> Blocks.IRON_BLOCK).properties(ModBlocks::steelProperties).item().tag(new TagKey[]{ItemTags.STAIRS}).build()).tag(new TagKey[]{BlockTags.STAIRS}).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).tag(new TagKey[]{BlockTags.NEEDS_STONE_TOOL}).blockstate((ctx, prov) -> prov.stairsBlock((StairBlock)ctx.get(), prov.modLoc("block/steel_sheet_metal"))).onRegister(CreateRegistrate.connectedTextures(SteelSheetMetalCTBehaviour::new))).register();
    public static final BlockEntry<SlabBlock> STEEL_SHEET_SLAB = ((BlockBuilder)((BlockBuilder)REGISTRATE.block("steel_sheet_slab", SlabBlock::new).initialProperties(() -> Blocks.IRON_BLOCK).properties(ModBlocks::steelProperties).item().tag(new TagKey[]{ItemTags.SLABS}).build()).tag(new TagKey[]{BlockTags.SLABS}).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).tag(new TagKey[]{BlockTags.NEEDS_STONE_TOOL}).blockstate((ctx, prov) -> prov.slabBlock((SlabBlock)ctx.get(), prov.modLoc("block/steel_sheet_metal"), prov.modLoc("block/steel_sheet_metal"))).loot((table, block) -> {
        LootTable.Builder builder = LootTable.lootTable();
        LootPool.Builder lootPool = LootPool.lootPool();
        lootPool.setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.DOUBLE)))));
        table.add((Block)block, builder.withPool(lootPool));
    }).onRegister(CreateRegistrate.connectedTextures(SteelSheetSlabCTBehaviour::new))).register();
    public static final BlockEntry<IronBarsBlock> STEEL_BARS = ((BlockBuilder)REGISTRATE.block("steel_bars", IronBarsBlock::new).initialProperties(() -> Blocks.IRON_BARS).properties(ModBlocks::steelProperties).tag(new TagKey[]{BlockTags.WALLS}).item().tag(new TagKey[]{ItemTags.WALLS}).build()).addLayer(() -> RenderType::cutoutMipped).tag(new TagKey[]{AllTags.AllBlockTags.FAN_TRANSPARENT.tag}).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).tag(new TagKey[]{BlockTags.NEEDS_STONE_TOOL}).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)16).pattern("###").pattern("###").define(Character.valueOf('#'), ModTags.Items.STEEL_INGOT).unlockedBy("has_ingredient", RegistrateRecipeProvider.has(ModTags.Items.STEEL_INGOT)).save((RecipeOutput)prov, Alloyed.asResource("crafting/" + ctx.getName()))).register();
    public static final BlockEntry<TrapDoorBlock> STEEL_TRAPDOOR = ((BlockBuilder)REGISTRATE.block("steel_trapdoor", properties -> new TrapDoorBlock(ModBlockSetTypes.STEEL, properties)).initialProperties(() -> Blocks.IRON_TRAPDOOR).properties(ModBlocks::steelProperties).blockstate((ctx, prov) -> prov.trapdoorBlock((TrapDoorBlock)ctx.get(), prov.modLoc("block/steel_trapdoor"), true)).tag(new TagKey[]{BlockTags.TRAPDOORS}).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).tag(new TagKey[]{BlockTags.NEEDS_STONE_TOOL}).item().model((ctx, prov) -> prov.withExistingParent(ctx.getName(), prov.modLoc("block/steel_trapdoor_bottom"))).tag(new TagKey[]{ItemTags.TRAPDOORS}).build()).addLayer(() -> RenderType::cutoutMipped).tag(new TagKey[]{AllTags.AllBlockTags.FAN_TRANSPARENT.tag}).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).pattern("##").pattern("##").define(Character.valueOf('#'), ModTags.Items.STEEL_INGOT).unlockedBy("has_ingredient", RegistrateRecipeProvider.has(ModTags.Items.STEEL_INGOT)).save((RecipeOutput)prov, Alloyed.asResource("crafting/" + ctx.getName()))).register();
    public static final BlockEntry<MetalLadderBlock> STEEL_LADDER = ((BlockBuilder)REGISTRATE.block("steel_ladder", MetalLadderBlock::new).transform((NonNullFunction)BuilderTransformers.ladder((String)"steel", () -> DataIngredient.tag(ModTags.Items.STEEL_SHEET), (MapColor)MapColor.COLOR_GRAY))).blockstate((ctx, prov) -> prov.horizontalBlock((Block)ctx.get(), (ModelFile)prov.models().getExistingFile(prov.modLoc("block/steel_ladder")))).lang("Steel Ladder").register();
    public static final BlockEntry<FenceBlock> STEEL_MESH_FENCE = ((BlockBuilder)REGISTRATE.block("steel_mesh_fence", FenceBlock::new).initialProperties(() -> Blocks.IRON_BLOCK).properties(properties -> properties.sound(SoundType.CHAIN)).tag(new TagKey[]{BlockTags.FENCES}).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).item().build()).addLayer(() -> RenderType::cutoutMipped).register();

    public static void register() {
        Alloyed.LOGGER.debug("Registering ModBlocks!");
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BlockBehaviour.Properties steelProperties(BlockBehaviour.Properties properties) {
        return properties.sound(SoundType.NETHERITE_BLOCK).strength(5.0f, 14.0f).mapColor(MapColor.COLOR_GRAY);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BlockBehaviour.Properties bronzeProperties(BlockBehaviour.Properties properties) {
        return properties.sound(SoundType.COPPER).strength(3.0f, 6.0f).mapColor(MapColor.COLOR_ORANGE);
    }

    public static void fixBronzeBlocks() {
    }

    private static List<BlockEntry<? extends Block>> registerBronzePillarSet(String id, WeatheringCopper.WeatherState state, CTSpriteShiftEntry pillar, CTSpriteShiftEntry cap) {
        BlockEntry block = ((BlockBuilder)((BlockBuilder)REGISTRATE.block(id, properties -> new WeatheringBronzePillarBlock(state, (BlockBehaviour.Properties)properties)).properties(ModBlocks::bronzeProperties).item().build()).onRegister(CreateRegistrate.connectedTextures(() -> new RotatedPillarCTBehaviour(pillar, cap)))).register();
        BlockEntry waxedBlock = ((BlockBuilder)((BlockBuilder)REGISTRATE.block("waxed_" + id, ConnectedPillarBlock::new).properties(ModBlocks::bronzeProperties).item().build()).onRegister(CreateRegistrate.connectedTextures(() -> new RotatedPillarCTBehaviour(pillar, cap)))).register();
        return List.of(block, waxedBlock);
    }

    private static List<BlockEntry<? extends Block>> registerCutBronzeSet(String id, WeatheringCopper.WeatherState state) {
        BlockEntry<? extends Block> block = ModBlocks.registerCutBronze(id, state);
        BlockEntry<WeatheringCopperStairBlock> stairs = ModBlocks.registerCutBronzeStairs(id, state);
        BlockEntry<? extends SlabBlock> slab = ModBlocks.registerCutBronzeSlab(id, state);
        BlockEntry waxedBlock = ((BlockBuilder)REGISTRATE.block("waxed_" + id, Block::new).initialProperties(() -> Blocks.CUT_COPPER).properties(ModBlocks::steelProperties).simpleItem().tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).tag(new TagKey[]{BlockTags.NEEDS_STONE_TOOL}).onRegister(CreateRegistrate.connectedTextures(SteelSheetMetalCTBehaviour::new))).register();
        BlockEntry waxedStairs = ((BlockBuilder)((BlockBuilder)REGISTRATE.block("waxed_" + id + "_stairs", properties -> new WeatheringCopperStairBlock(state, Blocks.BRICK_STAIRS.defaultBlockState(), properties)).initialProperties(() -> Blocks.CUT_COPPER).properties(ModBlocks::steelProperties).item().tag(new TagKey[]{ItemTags.STAIRS}).build()).tag(new TagKey[]{BlockTags.STAIRS}).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).tag(new TagKey[]{BlockTags.NEEDS_STONE_TOOL}).blockstate((ctx, prov) -> prov.stairsBlock((StairBlock)ctx.get(), prov.modLoc("block/cut_bronze"))).onRegister(CreateRegistrate.connectedTextures(SteelSheetMetalCTBehaviour::new))).register();
        BlockEntry waxedSlab = ((BlockBuilder)((BlockBuilder)REGISTRATE.block("waxed_" + id + "_slab", SlabBlock::new).initialProperties(() -> Blocks.CUT_COPPER).properties(ModBlocks::steelProperties).item().tag(new TagKey[]{ItemTags.SLABS}).build()).tag(new TagKey[]{BlockTags.SLABS}).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).tag(new TagKey[]{BlockTags.NEEDS_STONE_TOOL}).blockstate((ctx, prov) -> prov.slabBlock((SlabBlock)ctx.get(), prov.modLoc("block/cut_bronze"), prov.modLoc("block/cut_bronze"))).onRegister(CreateRegistrate.connectedTextures(SteelSheetSlabCTBehaviour::new))).register();
        return List.of(block, stairs, slab, waxedBlock, waxedStairs, waxedSlab);
    }

    private static BlockEntry<? extends Block> registerCutBronze(String id, WeatheringCopper.WeatherState state) {
        return ((BlockBuilder)REGISTRATE.block(id, properties -> new WeatheringCopperFullBlock(state, properties)).initialProperties(() -> Blocks.CUT_COPPER).properties(ModBlocks::steelProperties).simpleItem().tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).tag(new TagKey[]{BlockTags.NEEDS_STONE_TOOL}).onRegister(CreateRegistrate.connectedTextures(SteelSheetMetalCTBehaviour::new))).register();
    }

    private static BlockEntry<? extends SlabBlock> registerCutBronzeSlab(String id, WeatheringCopper.WeatherState state) {
        return ((BlockBuilder)((BlockBuilder)REGISTRATE.block(id + "_slab", p -> new WeatheringCopperSlabBlock(state, p)).initialProperties(() -> Blocks.CUT_COPPER).properties(ModBlocks::steelProperties).item().tag(new TagKey[]{ItemTags.SLABS}).build()).tag(new TagKey[]{BlockTags.SLABS}).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).tag(new TagKey[]{BlockTags.NEEDS_STONE_TOOL}).blockstate((ctx, prov) -> prov.slabBlock((SlabBlock)ctx.get(), prov.modLoc("block/cut_bronze"), prov.modLoc("block/cut_bronze"))).loot((table, block) -> {
            LootTable.Builder builder = LootTable.lootTable();
            LootPool.Builder lootPool = LootPool.lootPool();
            lootPool.setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.DOUBLE)))));
            table.add((Block)block, builder.withPool(lootPool));
        }).onRegister(CreateRegistrate.connectedTextures(SteelSheetSlabCTBehaviour::new))).register();
    }

    private static BlockEntry<WeatheringCopperStairBlock> registerCutBronzeStairs(String id, WeatheringCopper.WeatherState state) {
        return ((BlockBuilder)((BlockBuilder)REGISTRATE.block(id + "_stairs", properties -> new WeatheringCopperStairBlock(state, Blocks.BRICK_STAIRS.defaultBlockState(), properties)).initialProperties(() -> Blocks.CUT_COPPER).properties(ModBlocks::steelProperties).item().tag(new TagKey[]{ItemTags.STAIRS}).build()).tag(new TagKey[]{BlockTags.STAIRS}).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).tag(new TagKey[]{BlockTags.NEEDS_STONE_TOOL}).blockstate((ctx, prov) -> prov.stairsBlock((StairBlock)ctx.get(), prov.modLoc("block/cut_bronze"))).onRegister(CreateRegistrate.connectedTextures(SteelSheetMetalCTBehaviour::new))).register();
    }

    private static BlockBuilder<SteelDoorBlock, CreateRegistrate> steelDoorBlock(boolean locked, @Nullable BlockEntry<SteelDoorBlock> normalDoor) {
        String path = "block/" + (locked ? "locked_" : "") + "steel_door/";
        String name = (locked ? "locked_" : "") + "steel_door";
        return ((BlockBuilder)REGISTRATE.block(name, properties -> new SteelDoorBlock((BlockBehaviour.Properties)properties, locked)).item().build()).properties(properties -> properties.noOcclusion().sound(SoundType.METAL).strength(5.0f).requiresCorrectToolForDrops()).blockstate((ctx, prov) -> prov.doorBlock((DoorBlock)ctx.get(), path + ctx.getName(), prov.modLoc("block/" + name + "/bottom"), prov.modLoc("block/" + name + "/top"))).tag(new TagKey[]{BlockTags.NEEDS_STONE_TOOL, BlockTags.MINEABLE_WITH_PICKAXE, BlockTags.DOORS}).recipe((ctx, prov) -> {
            if (!locked) {
                ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).pattern("##").pattern("##").pattern("##").define(Character.valueOf('#'), ModTags.Items.STEEL_INGOT).unlockedBy("has_ingredient", RegistrateRecipeProvider.has(ModTags.Items.STEEL_INGOT)).save((RecipeOutput)prov, Alloyed.asResource("crafting/" + name));
            } else {
                DoorBlock door = (DoorBlock)Objects.requireNonNull(normalDoor).get();
                ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).requires((ItemLike)Items.REDSTONE_TORCH).requires((ItemLike)door).unlockedBy("has_ingredient", RegistrateRecipeProvider.has((ItemLike)door)).save((RecipeOutput)prov, Alloyed.asResource("crafting/" + name));
            }
        }).loot((lootTable, door) -> {
            LootTable.Builder tableBuilder = LootTable.lootTable();
            LootPool.Builder poolBuilder = LootPool.lootPool();
            poolBuilder.setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)door)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)door).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)));
            lootTable.add((Block)door, tableBuilder.withPool(poolBuilder));
        });
    }
}

