/*
 * Decompiled with CFR 0.152.
 */
package com.molybdenum.alloyed.common.content.blocks;

import com.molybdenum.alloyed.client.registry.ModSoundEvents;
import com.simibubi.create.AllItems;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
public class BronzeBellBlock
extends Block {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final IntegerProperty NOTE = BlockStateProperties.NOTE;

    public BronzeBellBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)NOTE, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{POWERED, NOTE});
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        boolean isPowered = pLevel.hasNeighborSignal(pPos);
        if (isPowered != (Boolean)pState.getValue((Property)POWERED)) {
            if (isPowered) {
                this.attemptToRing(pLevel, pPos);
            }
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered)), 3);
        }
    }

    public void onProjectileHit(Level pLevel, BlockState pState, BlockHitResult pHit, Projectile pProjectile) {
        Entity entity = pProjectile.getOwner();
        Player player = entity instanceof Player ? (Player)entity : null;
        this.onHit(pLevel, pHit, player, true);
    }

    private void playNote(BlockState pState, Level pLevel, BlockPos pPos, BlockHitResult pHit) {
        if (this.isProperHit(pHit.getDirection())) {
            int i = (Integer)pState.getValue((Property)NOTE);
            pLevel.addParticle((ParticleOptions)ParticleTypes.NOTE, (double)pPos.getX() + 0.5, (double)pPos.getY() + 1.2, (double)pPos.getZ() + 0.5, (double)i / 24.0, 0.0, 0.0);
        }
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        this.playNote(pState, pLevel, pPos, pHit);
        return this.onHit(pLevel, pHit, pPlayer, true) ? InteractionResult.sidedSuccess((boolean)pLevel.isClientSide) : InteractionResult.PASS;
    }

    protected ItemInteractionResult useItemOn(ItemStack arg, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (this.isProperHit(pHit.getDirection()) && AllItems.WRENCH.isIn(arg)) {
            pState = (BlockState)pState.cycle((Property)NOTE);
            pLevel.setBlock(pPos, pState, 3);
            this.playNote(pState, pLevel, pPos, pHit);
        }
        if (this.onHit(pLevel, pHit, pPlayer, true)) {
            return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean onHit(Level pLevel, BlockHitResult pResult, @Nullable Player pPlayer, boolean pCanRingBell) {
        boolean canRing;
        Direction direction = pResult.getDirection();
        BlockPos blockpos = pResult.getBlockPos();
        boolean bl = canRing = !pCanRingBell || this.isProperHit(direction);
        if (canRing) {
            this.attemptToRing(pLevel, blockpos);
            if (pPlayer != null) {
                pPlayer.awardStat(Stats.BELL_RING);
            }
            return true;
        }
        return false;
    }

    private boolean isProperHit(Direction pDirection) {
        return pDirection.getAxis() != Direction.Axis.Y;
    }

    public void attemptToRing(Level pLevel, BlockPos pPos) {
        pLevel.blockEvent(pPos, (Block)this, 0, 0);
    }

    public boolean triggerEvent(BlockState pState, Level pLevel, BlockPos pPos, int pId, int pParam) {
        int i = (Integer)pState.getValue((Property)NOTE);
        float f = (float)Math.pow(2.0, (double)(i - 12) / 12.0);
        pLevel.playSound(null, pPos, (SoundEvent)ModSoundEvents.BRONZE_BELL.get(), SoundSource.RECORDS, 5.0f, f);
        return true;
    }
}

