/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.ingredient;

import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemStack;

public class CreativeIngredientItem
extends CreativeIngredient {
    public Item item;

    public CreativeIngredientItem(Item item) {
        this.item = item;
    }

    public CreativeIngredientItem() {
    }

    @Override
    protected void saveExtra(HolderLookup.Provider provider, CompoundTag nbt) {
        nbt.putString("item", this.item.builtInRegistryHolder().getRegisteredName());
    }

    @Override
    protected void loadExtra(HolderLookup.Provider provider, CompoundTag nbt) {
        this.item = (Item)((HolderLookup.RegistryLookup)provider.lookup(Registries.ITEM).get()).get(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)nbt.getString("item")))).orElse(Items.AIR.builtInRegistryHolder()).value();
    }

    @Override
    public ItemStack getExample() {
        return new ItemStack((ItemLike)this.item);
    }

    @Override
    public boolean is(CreativeIngredient info) {
        if (info instanceof CreativeIngredientItem) {
            return ((CreativeIngredientItem)info).item == this.item;
        }
        if (info instanceof CreativeIngredientItemStack) {
            return this.item == ((CreativeIngredientItemStack)info).stack.getItem();
        }
        return false;
    }

    @Override
    public boolean is(ItemStack stack) {
        return stack.getItem() == this.item;
    }

    @Override
    public boolean equals(CreativeIngredient object) {
        return object instanceof CreativeIngredientItem && ((CreativeIngredientItem)object).item == this.item;
    }

    @Override
    public CreativeIngredient copy() {
        return new CreativeIngredientItem(this.item);
    }

    @Override
    public Component description() {
        return Component.translatable((String)this.item.getDescriptionId());
    }

    @Override
    public Component descriptionDetail() {
        return Component.translatable((String)"minecraft.item").append(": " + String.valueOf(ChatFormatting.YELLOW) + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)this.item)));
    }
}

