/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import team.creative.creativecore.common.config.gui.GuiInfoStackButton;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.control.parent.GuiScrollY;
import team.creative.creativecore.common.gui.control.parent.GuiTopBottomBox;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.ingredient.GuiCreativeIngredientHandler;
import team.creative.creativecore.common.util.text.TextMapBuilder;

public class FullItemDialogGuiLayer
extends GuiLayer {
    public static List<CreativeIngredient> latest = new ArrayList<CreativeIngredient>();
    public GuiInfoStackButton button;
    public GuiCreativeIngredientHandler handler;

    public FullItemDialogGuiLayer() {
        super("info", 250, 230);
        this.flow = GuiFlow.STACK_Y;
        this.registerEventChanged(x -> {
            if (x.control.is("type")) {
                this.init();
            } else {
                this.handler.onChanged(this, (GuiControlChangedEvent)x);
            }
        });
    }

    @Override
    public void create() {
        if (this.button == null) {
            return;
        }
        CreativeIngredient info = this.button.get();
        this.handler = GuiCreativeIngredientHandler.find(info);
        GuiComboBox<GuiCreativeIngredientHandler> box = (GuiComboBox<GuiCreativeIngredientHandler>)this.get("type");
        if (box != null) {
            this.handler = (GuiCreativeIngredientHandler)box.selected();
        }
        this.clear();
        GuiTopBottomBox topBottom = new GuiTopBottomBox();
        this.add((GuiControl)topBottom);
        box = new GuiComboBox<GuiCreativeIngredientHandler>("type", new TextMapBuilder().addEntrySet(GuiCreativeIngredientHandler.REGISTRY.entrySet(), x -> Component.literal((String)((String)x.getKey()))));
        box.setExpandableX();
        box.select(this.handler);
        topBottom.addTop(box);
        this.handler.createControls(topBottom.top, info);
        topBottom.addBottom(new GuiParent("spacer").setDim(-1, 4));
        topBottom.addBottom(new GuiLabel("latest").setTranslate("gui.ingredient.latest"));
        GuiScrollY scroll = (GuiScrollY)new GuiScrollY("latest").setDim(100, 40).setExpandableX();
        for (int i = 0; i < latest.size(); ++i) {
            int id = i;
            scroll.add(new GuiButton("" + i, x -> {
                this.button.set(latest.get(id));
                this.closeTopLayer();
                FullItemDialogGuiLayer.playSound((Holder.Reference<SoundEvent>)SoundEvents.UI_BUTTON_CLICK);
            }).setTitle(GuiInfoStackButton.getLabelText(latest.get(i))).setAlign(Align.CENTER).setExpandableX());
        }
        topBottom.addBottom(scroll);
        GuiLeftRightBox actionBox = new GuiLeftRightBox().addLeft(new GuiButton("cancel", x -> this.closeTopLayer()).setTitle((Component)Component.translatable((String)"gui.cancel"))).addRight(new GuiButton("save", x -> {
            CreativeIngredient parsedInfo = this.handler.parseControls(topBottom.top);
            if (parsedInfo != null) {
                this.button.set(parsedInfo);
                if (!latest.contains(parsedInfo)) {
                    latest.add(0, parsedInfo.copy());
                }
                this.closeTopLayer();
            }
        }).setTitle((Component)Component.translatable((String)"gui.save")));
        topBottom.addBottom(actionBox);
    }
}

