/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.brewing;

import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public record BrewingRecipeRegistry(List<IBrewingRecipe> recipes) {
    public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
        if (input.isEmpty() || input.getCount() != 1) {
            return ItemStack.EMPTY;
        }
        if (ingredient.isEmpty()) {
            return ItemStack.EMPTY;
        }
        for (IBrewingRecipe recipe : this.recipes) {
            ItemStack output = recipe.getOutput(input, ingredient);
            if (output.isEmpty()) continue;
            return output;
        }
        return ItemStack.EMPTY;
    }

    public boolean hasOutput(ItemStack input, ItemStack ingredient) {
        return !this.getOutput(input, ingredient).isEmpty();
    }

    public boolean isValidIngredient(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        for (IBrewingRecipe recipe : this.recipes) {
            if (!recipe.isIngredient(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidInput(ItemStack stack) {
        for (IBrewingRecipe recipe : this.recipes) {
            if (!recipe.isInput(stack)) continue;
            return true;
        }
        return false;
    }
}

