/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.ui;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import net.minecraftforge.installer.ui.TranslatedMessage;
import net.minecraftforge.installer.ui.TranslationTarget;
import org.jetbrains.annotations.NotNull;

public class L10nManager {
    private static final ResourceBundle.Control CONTROL = new ResourceBundle.Control(){

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            if (format.equals("java.class")) {
                return super.newBundle(baseName, locale, format, loader, reload);
            }
            if (!format.equals("java.properties")) {
                throw new IllegalArgumentException("unknown format: " + format);
            }
            String bundleName = this.toBundleName(baseName, locale);
            if (bundleName.contains("://")) {
                return null;
            }
            String resourceName = this.toResourceName(bundleName, "xml");
            InputStream is = null;
            if (reload) {
                URLConnection connection;
                URL url = loader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    is = connection.getInputStream();
                }
            } else {
                is = loader.getResourceAsStream(resourceName);
            }
            if (is == null) {
                return null;
            }
            try (InputStream i = is;){
                Properties props = new Properties();
                props.loadFromXML(i);
                final HashMap<Object, Object> lookup = new HashMap<Object, Object>(props);
                ResourceBundle resourceBundle = new ResourceBundle(){

                    @Override
                    protected Object handleGetObject(@NotNull String key) {
                        return lookup.get(key);
                    }

                    @Override
                    @NotNull
                    public Enumeration<String> getKeys() {
                        return new MergedEnumeration(lookup.keySet(), this.parent != null ? this.parent.getKeys() : null);
                    }

                    @Override
                    @NotNull
                    protected Set<String> handleKeySet() {
                        return lookup.keySet();
                    }
                };
                return resourceBundle;
            }
        }
    };
    private final Map<Component, Map<TranslationTarget<?>, PropertyChangeListener>> components = new IdentityHashMap();
    private Locale locale;
    private ResourceBundle bundle;
    private final String bundleName;
    private final Path settingsFile;
    private final List<LocaleSelection> known;

    public L10nManager(String bundleName, Path settingsFile) {
        this.bundleName = bundleName;
        this.settingsFile = settingsFile;
        this.known = Collections.unmodifiableList(this.computeKnownLocales());
        if (Files.exists(this.settingsFile, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(this.settingsFile, new OpenOption[0]);){
                Properties props = new Properties();
                props.load(is);
                String lang = props.getProperty("language");
                if (lang == null) {
                    this.setDefaultLocale();
                } else {
                    this.setLocale(Locale.forLanguageTag(lang), false);
                }
            }
            catch (Exception exception) {
                System.err.println("Failed to read settings file: " + exception);
                this.setDefaultLocale();
            }
        } else {
            this.setDefaultLocale();
        }
    }

    private void setDefaultLocale() {
        String expected = Locale.getDefault().toLanguageTag();
        this.setLocale(this.known.stream().filter(se -> se.locale.toLanguageTag().equals(expected)).findFirst().map(l -> l.locale).orElse(Locale.ENGLISH), false);
    }

    public JButton button(String key, Object ... args) {
        return (JButton)this.translate(new JButton(), TranslationTarget.BUTTON_TEXT, key, args);
    }

    public JLabel label(String key, Object ... args) {
        return this.translate(new JLabel(), TranslationTarget.LABEL_TEXT, key, args);
    }

    public JRadioButton radioButton(AbstractAction action, String key, Object ... args) {
        JRadioButton button = new JRadioButton();
        button.setAction(action);
        return (JRadioButton)this.translate(button, TranslationTarget.BUTTON_TEXT, key, args);
    }

    public JCheckBox checkBox(String key, Object ... args) {
        return (JCheckBox)this.translate(new JCheckBox(), TranslationTarget.BUTTON_TEXT, key, args);
    }

    public <T extends JComponent> T setTooltip(T component, String key, Object ... args) {
        return (T)this.translate(component, TranslationTarget.TOOLTIP, key, args);
    }

    public <T extends Component> T translate(T component, TranslationTarget<? super T> target, String key, Object ... args) {
        Map listeners = this.components.computeIfAbsent(component, k -> new HashMap());
        if (listeners.containsKey(target)) {
            component.removePropertyChangeListener((PropertyChangeListener)listeners.get(target));
        }
        PropertyChangeListener pcl = evt -> target.setter.accept(component, this.translate(key, args));
        component.addPropertyChangeListener("locale", pcl);
        if (component.getLocale().equals(this.locale)) {
            target.setter.accept(component, this.translate(key, args));
        } else {
            component.setLocale(this.locale);
        }
        listeners.put(target, pcl);
        return component;
    }

    public synchronized String translate(String key, Object ... args) {
        try {
            return String.format(this.bundle.getString(key), args);
        }
        catch (MissingResourceException ignored) {
            return String.format(key, args);
        }
    }

    public String translate(TranslatedMessage message) {
        return this.translate(message.key, message.arguments);
    }

    public synchronized void setLocale(Locale locale, boolean write) {
        this.locale = locale;
        this.bundle = ResourceBundle.getBundle(this.bundleName, locale, CONTROL);
        this.components.keySet().forEach(comp -> comp.setLocale(locale));
        if (write) {
            try {
                Files.createDirectories(this.settingsFile.getParent(), new FileAttribute[0]);
                try (OutputStream os = Files.newOutputStream(this.settingsFile, new OpenOption[0]);){
                    Properties props = new Properties();
                    props.put("language", locale.toLanguageTag());
                    props.store(os, "NeoForge installer settings file");
                }
                Files.setAttribute(this.settingsFile, "dos:hidden", true, new LinkOption[0]);
            }
            catch (Exception exception) {
                System.err.println("Failed to write settings file: " + exception);
            }
        }
    }

    public synchronized Locale getLocale() {
        return this.locale;
    }

    public List<LocaleSelection> getKnownLocales() {
        return this.known;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LocaleSelection> computeKnownLocales() {
        try {
            HashSet<String> names = new HashSet<String>();
            ArrayList<LocaleSelection> selections = new ArrayList<LocaleSelection>();
            for (Locale locale : Locale.getAvailableLocales()) {
                InputStream is = L10nManager.class.getResourceAsStream("/" + CONTROL.toBundleName(this.bundleName, locale) + ".xml");
                if (is == null) continue;
                try {
                    Properties properties = new Properties();
                    properties.loadFromXML(is);
                    String name = locale.equals(Locale.ROOT) ? "english" : locale.getDisplayName(locale);
                    name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
                    if (!names.add(name) || name.equals("English") && !locale.equals(Locale.ROOT)) continue;
                    selections.add(new LocaleSelection(locale, name));
                }
                finally {
                    is.close();
                }
            }
            return selections;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to read languages: " + exception.getMessage(), exception);
        }
    }

    private static final class MergedEnumeration
    implements Enumeration<String> {
        private final Set<String> set;
        private final Iterator<String> iterator;
        private final Enumeration<String> enumeration;
        String next = null;

        public MergedEnumeration(Set<String> set, Enumeration<String> enumeration) {
            this.set = set;
            this.iterator = set.iterator();
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.next == null) {
                if (this.iterator.hasNext()) {
                    this.next = this.iterator.next();
                } else if (this.enumeration != null) {
                    while (this.next == null && this.enumeration.hasMoreElements()) {
                        this.next = this.enumeration.nextElement();
                        if (!this.set.contains(this.next)) continue;
                        this.next = null;
                    }
                }
            }
            return this.next != null;
        }

        @Override
        public String nextElement() {
            if (this.hasMoreElements()) {
                String result = this.next;
                this.next = null;
                return result;
            }
            throw new NoSuchElementException();
        }
    }

    public static final class LocaleSelection {
        public final Locale locale;
        public final String name;

        private LocaleSelection(Locale locale, String name) {
            this.locale = locale;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

