/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.AlterGroundEvent;

public class AlterGroundDecorator
extends TreeDecorator {
    public static final MapCodec<AlterGroundDecorator> CODEC = BlockStateProvider.CODEC.fieldOf("provider").xmap(AlterGroundDecorator::new, p_69327_ -> p_69327_.provider);
    private final BlockStateProvider provider;

    public AlterGroundDecorator(BlockStateProvider p_69306_) {
        this.provider = p_69306_;
    }

    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.ALTER_GROUND;
    }

    public void place(TreeDecorator.Context p_225969_) {
        ArrayList list = Lists.newArrayList();
        ObjectArrayList list1 = p_225969_.roots();
        ObjectArrayList list2 = p_225969_.logs();
        if (list1.isEmpty()) {
            list.addAll(list2);
        } else if (!list2.isEmpty() && ((BlockPos)list1.get(0)).getY() == ((BlockPos)list2.get(0)).getY()) {
            list.addAll(list2);
            list.addAll(list1);
        } else {
            list.addAll(list1);
        }
        if (!list.isEmpty()) {
            AlterGroundEvent.StateProvider eventProvider = EventHooks.alterGround((TreeDecorator.Context)p_225969_, (List)list, (arg_0, arg_1) -> ((BlockStateProvider)this.provider).getState(arg_0, arg_1));
            int i = ((BlockPos)list.get(0)).getY();
            list.stream().filter(p_69310_ -> p_69310_.getY() == i).forEach(p_225978_ -> {
                this.placeCircle(p_225969_, p_225978_.west().north(), eventProvider);
                this.placeCircle(p_225969_, p_225978_.east(2).north(), eventProvider);
                this.placeCircle(p_225969_, p_225978_.west().south(2), eventProvider);
                this.placeCircle(p_225969_, p_225978_.east(2).south(2), eventProvider);
                for (int j = 0; j < 5; ++j) {
                    int k = p_225969_.random().nextInt(64);
                    int l = k % 8;
                    int i1 = k / 8;
                    if (l != 0 && l != 7 && i1 != 0 && i1 != 7) continue;
                    this.placeCircle(p_225969_, p_225978_.offset(-3 + l, 0, -3 + i1), eventProvider);
                }
            });
        }
    }

    private void placeCircle(TreeDecorator.Context p_225971_, BlockPos p_225972_) {
        this.placeCircle(p_225971_, p_225972_, (arg_0, arg_1) -> ((BlockStateProvider)this.provider).getState(arg_0, arg_1));
    }

    private void placeCircle(TreeDecorator.Context p_225971_, BlockPos p_225972_, AlterGroundEvent.StateProvider eventProvider) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                this.placeBlockAt(p_225971_, p_225972_.offset(i, 0, j), eventProvider);
            }
        }
    }

    private void placeBlockAt(TreeDecorator.Context p_225974_, BlockPos p_225975_) {
        this.placeCircle(p_225974_, p_225975_, (arg_0, arg_1) -> ((BlockStateProvider)this.provider).getState(arg_0, arg_1));
    }

    private void placeBlockAt(TreeDecorator.Context p_225974_, BlockPos p_225975_, AlterGroundEvent.StateProvider eventProvider) {
        for (int i = 2; i >= -3; --i) {
            BlockPos blockpos = p_225975_.above(i);
            if (Feature.isGrassOrDirt((LevelSimulatedReader)p_225974_.level(), (BlockPos)blockpos)) {
                p_225974_.setBlock(blockpos, eventProvider.getState(p_225974_.random(), p_225975_));
                break;
            }
            if (!p_225974_.isAir(blockpos) && i < 0) break;
        }
    }
}

