/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.RenderBlockScreenEffectEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidType;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class ScreenEffectRenderer {
    private static final ResourceLocation UNDERWATER_LOCATION = ResourceLocation.withDefaultNamespace("textures/misc/underwater.png");

    public static void renderScreenEffect(Minecraft p_110719_, PoseStack p_110720_) {
        Pair<BlockState, BlockPos> overlay;
        LocalPlayer player = p_110719_.player;
        if (!player.noPhysics && (overlay = ScreenEffectRenderer.getOverlayBlock(player)) != null && !ClientHooks.renderBlockOverlay((Player)player, (PoseStack)p_110720_, (RenderBlockScreenEffectEvent.OverlayType)RenderBlockScreenEffectEvent.OverlayType.BLOCK, (BlockState)((BlockState)((Object)overlay.getLeft())), (BlockPos)((BlockPos)overlay.getRight()))) {
            ScreenEffectRenderer.renderTex(p_110719_.getBlockRenderer().getBlockModelShaper().getTexture((BlockState)((Object)overlay.getLeft()), p_110719_.level, (BlockPos)overlay.getRight()), p_110720_);
        }
        if (!p_110719_.player.isSpectator()) {
            if (p_110719_.player.isEyeInFluid(FluidTags.WATER)) {
                if (!ClientHooks.renderWaterOverlay((Player)player, (PoseStack)p_110720_)) {
                    ScreenEffectRenderer.renderWater(p_110719_, p_110720_);
                }
            } else if (!player.getEyeInFluidType().isAir()) {
                IClientFluidTypeExtensions.of((FluidType)player.getEyeInFluidType()).renderOverlay(p_110719_, p_110720_);
            }
            if (p_110719_.player.isOnFire() && !ClientHooks.renderFireOverlay((Player)player, (PoseStack)p_110720_)) {
                ScreenEffectRenderer.renderFire(p_110719_, p_110720_);
            }
        }
    }

    @Nullable
    private static BlockState getViewBlockingState(Player p_110717_) {
        return (BlockState)((Object)ScreenEffectRenderer.getOverlayBlock(p_110717_).getLeft());
    }

    @Nullable
    private static Pair<BlockState, BlockPos> getOverlayBlock(Player p_110717_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 8; ++i) {
            double d0 = p_110717_.getX() + (double)(((float)((i >> 0) % 2) - 0.5f) * p_110717_.getBbWidth() * 0.8f);
            double d1 = p_110717_.getEyeY() + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f * p_110717_.getScale());
            double d2 = p_110717_.getZ() + (double)(((float)((i >> 2) % 2) - 0.5f) * p_110717_.getBbWidth() * 0.8f);
            blockpos$mutableblockpos.set(d0, d1, d2);
            BlockState blockstate = p_110717_.level().getBlockState((BlockPos)blockpos$mutableblockpos);
            if (blockstate.getRenderShape() == RenderShape.INVISIBLE || !blockstate.isViewBlocking((BlockGetter)((Object)p_110717_.level()), (BlockPos)blockpos$mutableblockpos)) continue;
            return Pair.of((Object)((Object)blockstate), (Object)blockpos$mutableblockpos.immutable());
        }
        return null;
    }

    private static void renderTex(TextureAtlasSprite p_173297_, PoseStack p_173298_) {
        RenderSystem.setShaderTexture(0, p_173297_.atlasLocation());
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        float f = 0.1f;
        float f1 = -1.0f;
        float f2 = 1.0f;
        float f3 = -1.0f;
        float f4 = 1.0f;
        float f5 = -0.5f;
        float f6 = p_173297_.getU0();
        float f7 = p_173297_.getU1();
        float f8 = p_173297_.getV0();
        float f9 = p_173297_.getV1();
        Matrix4f matrix4f = p_173298_.last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.addVertex(matrix4f, -1.0f, -1.0f, -0.5f).setUv(f7, f9).setColor(0.1f, 0.1f, 0.1f, 1.0f);
        bufferbuilder.addVertex(matrix4f, 1.0f, -1.0f, -0.5f).setUv(f6, f9).setColor(0.1f, 0.1f, 0.1f, 1.0f);
        bufferbuilder.addVertex(matrix4f, 1.0f, 1.0f, -0.5f).setUv(f6, f8).setColor(0.1f, 0.1f, 0.1f, 1.0f);
        bufferbuilder.addVertex(matrix4f, -1.0f, 1.0f, -0.5f).setUv(f7, f8).setColor(0.1f, 0.1f, 0.1f, 1.0f);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    private static void renderWater(Minecraft p_110726_, PoseStack p_110727_) {
        ScreenEffectRenderer.renderFluid(p_110726_, p_110727_, UNDERWATER_LOCATION);
    }

    public static void renderFluid(Minecraft p_110726_, PoseStack p_110727_, ResourceLocation texture) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture(0, texture);
        BlockPos blockpos = BlockPos.containing((double)p_110726_.player.getX(), (double)p_110726_.player.getEyeY(), (double)p_110726_.player.getZ());
        float f = LightTexture.getBrightness(p_110726_.player.level().dimensionType(), p_110726_.player.level().getMaxLocalRawBrightness(blockpos));
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor(f, f, f, 0.1f);
        float f1 = 4.0f;
        float f2 = -1.0f;
        float f3 = 1.0f;
        float f4 = -1.0f;
        float f5 = 1.0f;
        float f6 = -0.5f;
        float f7 = -p_110726_.player.getYRot() / 64.0f;
        float f8 = p_110726_.player.getXRot() / 64.0f;
        Matrix4f matrix4f = p_110727_.last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f, -1.0f, -1.0f, -0.5f).setUv(4.0f + f7, 4.0f + f8);
        bufferbuilder.addVertex(matrix4f, 1.0f, -1.0f, -0.5f).setUv(0.0f + f7, 4.0f + f8);
        bufferbuilder.addVertex(matrix4f, 1.0f, 1.0f, -0.5f).setUv(0.0f + f7, 0.0f + f8);
        bufferbuilder.addVertex(matrix4f, -1.0f, 1.0f, -0.5f).setUv(4.0f + f7, 0.0f + f8);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
    }

    private static void renderFire(Minecraft p_110729_, PoseStack p_110730_) {
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.depthFunc(519);
        RenderSystem.depthMask(false);
        RenderSystem.enableBlend();
        TextureAtlasSprite textureatlassprite = ModelBakery.FIRE_1.sprite();
        RenderSystem.setShaderTexture(0, textureatlassprite.atlasLocation());
        float f = textureatlassprite.getU0();
        float f1 = textureatlassprite.getU1();
        float f2 = (f + f1) / 2.0f;
        float f3 = textureatlassprite.getV0();
        float f4 = textureatlassprite.getV1();
        float f5 = (f3 + f4) / 2.0f;
        float f6 = textureatlassprite.uvShrinkRatio();
        float f7 = Mth.lerp((float)f6, (float)f, (float)f2);
        float f8 = Mth.lerp((float)f6, (float)f1, (float)f2);
        float f9 = Mth.lerp((float)f6, (float)f3, (float)f5);
        float f10 = Mth.lerp((float)f6, (float)f4, (float)f5);
        float f11 = 1.0f;
        for (int i = 0; i < 2; ++i) {
            p_110730_.pushPose();
            float f12 = -0.5f;
            float f13 = 0.5f;
            float f14 = -0.5f;
            float f15 = 0.5f;
            float f16 = -0.5f;
            p_110730_.translate((float)(-(i * 2 - 1)) * 0.24f, -0.3f, 0.0f);
            p_110730_.mulPose(Axis.YP.rotationDegrees((float)(i * 2 - 1) * 10.0f));
            Matrix4f matrix4f = p_110730_.last().pose();
            BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            bufferbuilder.addVertex(matrix4f, -0.5f, -0.5f, -0.5f).setUv(f8, f10).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            bufferbuilder.addVertex(matrix4f, 0.5f, -0.5f, -0.5f).setUv(f7, f10).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            bufferbuilder.addVertex(matrix4f, 0.5f, 0.5f, -0.5f).setUv(f7, f9).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            bufferbuilder.addVertex(matrix4f, -0.5f, 0.5f, -0.5f).setUv(f8, f9).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            p_110730_.popPose();
        }
        RenderSystem.disableBlend();
        RenderSystem.depthMask(true);
        RenderSystem.depthFunc(515);
    }
}

