/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ChainedJsonException;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.GsonHelper;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class PostChain
implements AutoCloseable {
    private static final String MAIN_RENDER_TARGET = "minecraft:main";
    private final RenderTarget screenTarget;
    private final ResourceProvider resourceProvider;
    private final String name;
    private final List<PostPass> passes = Lists.newArrayList();
    private final Map<String, RenderTarget> customRenderTargets = Maps.newHashMap();
    private final List<RenderTarget> fullSizedTargets = Lists.newArrayList();
    private Matrix4f shaderOrthoMatrix;
    private int screenWidth;
    private int screenHeight;
    private float time;
    private float lastStamp;

    public PostChain(TextureManager p_110018_, ResourceProvider p_330592_, RenderTarget p_110020_, ResourceLocation p_110021_) throws IOException, JsonSyntaxException {
        this.resourceProvider = p_330592_;
        this.screenTarget = p_110020_;
        this.time = 0.0f;
        this.lastStamp = 0.0f;
        this.screenWidth = p_110020_.viewWidth;
        this.screenHeight = p_110020_.viewHeight;
        this.name = p_110021_.toString();
        this.updateOrthoMatrix();
        this.load(p_110018_, p_110021_);
    }

    private void load(TextureManager p_110034_, ResourceLocation p_110035_) throws IOException, JsonSyntaxException {
        block15: {
            Resource resource = this.resourceProvider.getResourceOrThrow(p_110035_);
            try (BufferedReader reader = resource.openAsReader();){
                JsonObject jsonobject = GsonHelper.parse((Reader)reader);
                if (GsonHelper.isArrayNode((JsonObject)jsonobject, (String)"targets")) {
                    JsonArray jsonarray = jsonobject.getAsJsonArray("targets");
                    int i = 0;
                    for (JsonElement jsonelement : jsonarray) {
                        try {
                            this.parseTargetNode(jsonelement);
                        }
                        catch (Exception exception1) {
                            ChainedJsonException chainedjsonexception1 = ChainedJsonException.forException((Exception)exception1);
                            chainedjsonexception1.prependJsonKey("targets[" + i + "]");
                            throw chainedjsonexception1;
                        }
                        ++i;
                    }
                }
                if (!GsonHelper.isArrayNode((JsonObject)jsonobject, (String)"passes")) break block15;
                JsonArray jsonarray1 = jsonobject.getAsJsonArray("passes");
                int j = 0;
                for (JsonElement jsonelement1 : jsonarray1) {
                    try {
                        this.parsePassNode(p_110034_, jsonelement1);
                    }
                    catch (Exception exception) {
                        ChainedJsonException chainedjsonexception2 = ChainedJsonException.forException((Exception)exception);
                        chainedjsonexception2.prependJsonKey("passes[" + j + "]");
                        throw chainedjsonexception2;
                    }
                    ++j;
                }
            }
            catch (Exception exception2) {
                ChainedJsonException chainedjsonexception = ChainedJsonException.forException((Exception)exception2);
                chainedjsonexception.setFilenameAndFlush(p_110035_.getPath() + " (" + resource.sourcePackId() + ")");
                throw chainedjsonexception;
            }
        }
    }

    private void parseTargetNode(JsonElement p_110029_) throws ChainedJsonException {
        if (GsonHelper.isStringValue((JsonElement)p_110029_)) {
            this.addTempTarget(p_110029_.getAsString(), this.screenWidth, this.screenHeight);
        } else {
            JsonObject jsonobject = GsonHelper.convertToJsonObject((JsonElement)p_110029_, (String)"target");
            String s = GsonHelper.getAsString((JsonObject)jsonobject, (String)"name");
            int i = GsonHelper.getAsInt((JsonObject)jsonobject, (String)"width", (int)this.screenWidth);
            int j = GsonHelper.getAsInt((JsonObject)jsonobject, (String)"height", (int)this.screenHeight);
            if (this.customRenderTargets.containsKey(s)) {
                throw new ChainedJsonException(s + " is already defined");
            }
            this.addTempTarget(s, i, j);
        }
    }

    private void parsePassNode(TextureManager p_110031_, JsonElement p_110032_) throws IOException {
        JsonArray jsonarray1;
        JsonObject jsonobject = GsonHelper.convertToJsonObject((JsonElement)p_110032_, (String)"pass");
        String s = GsonHelper.getAsString((JsonObject)jsonobject, (String)"name");
        String s1 = GsonHelper.getAsString((JsonObject)jsonobject, (String)"intarget");
        String s2 = GsonHelper.getAsString((JsonObject)jsonobject, (String)"outtarget");
        RenderTarget rendertarget = this.getRenderTarget(s1);
        RenderTarget rendertarget1 = this.getRenderTarget(s2);
        boolean flag = GsonHelper.getAsBoolean((JsonObject)jsonobject, (String)"use_linear_filter", (boolean)false);
        if (rendertarget == null) {
            throw new ChainedJsonException("Input target '" + s1 + "' does not exist");
        }
        if (rendertarget1 == null) {
            throw new ChainedJsonException("Output target '" + s2 + "' does not exist");
        }
        PostPass postpass = this.addPass(s, rendertarget, rendertarget1, flag);
        JsonArray jsonarray = GsonHelper.getAsJsonArray((JsonObject)jsonobject, (String)"auxtargets", null);
        if (jsonarray != null) {
            int i = 0;
            for (JsonElement jsonelement : jsonarray) {
                try {
                    String s4;
                    boolean flag1;
                    JsonObject jsonobject1 = GsonHelper.convertToJsonObject((JsonElement)jsonelement, (String)"auxtarget");
                    String s5 = GsonHelper.getAsString((JsonObject)jsonobject1, (String)"name");
                    String s3 = GsonHelper.getAsString((JsonObject)jsonobject1, (String)"id");
                    if (s3.endsWith(":depth")) {
                        flag1 = true;
                        s4 = s3.substring(0, s3.lastIndexOf(58));
                    } else {
                        flag1 = false;
                        s4 = s3;
                    }
                    RenderTarget rendertarget2 = this.getRenderTarget(s4);
                    if (rendertarget2 == null) {
                        if (flag1) {
                            throw new ChainedJsonException("Render target '" + s4 + "' can't be used as depth buffer");
                        }
                        ResourceLocation rl = ResourceLocation.tryParse(s4);
                        ResourceLocation resourcelocation = ResourceLocation.fromNamespaceAndPath(rl.getNamespace(), "textures/effect/" + rl.getPath() + ".png");
                        this.resourceProvider.getResource(resourcelocation).orElseThrow(() -> new ChainedJsonException("Render target or texture '" + s4 + "' does not exist"));
                        RenderSystem.setShaderTexture(0, resourcelocation);
                        p_110031_.bindForSetup(resourcelocation);
                        AbstractTexture abstracttexture = p_110031_.getTexture(resourcelocation);
                        int j = GsonHelper.getAsInt((JsonObject)jsonobject1, (String)"width");
                        int k = GsonHelper.getAsInt((JsonObject)jsonobject1, (String)"height");
                        boolean flag2 = GsonHelper.getAsBoolean((JsonObject)jsonobject1, (String)"bilinear");
                        if (flag2) {
                            RenderSystem.texParameter(3553, 10241, 9729);
                            RenderSystem.texParameter(3553, 10240, 9729);
                        } else {
                            RenderSystem.texParameter(3553, 10241, 9728);
                            RenderSystem.texParameter(3553, 10240, 9728);
                        }
                        postpass.addAuxAsset(s5, abstracttexture::getId, j, k);
                    } else if (flag1) {
                        postpass.addAuxAsset(s5, rendertarget2::getDepthTextureId, rendertarget2.width, rendertarget2.height);
                    } else {
                        postpass.addAuxAsset(s5, rendertarget2::getColorTextureId, rendertarget2.width, rendertarget2.height);
                    }
                }
                catch (Exception exception1) {
                    ChainedJsonException chainedjsonexception = ChainedJsonException.forException((Exception)exception1);
                    chainedjsonexception.prependJsonKey("auxtargets[" + i + "]");
                    throw chainedjsonexception;
                }
                ++i;
            }
        }
        if ((jsonarray1 = GsonHelper.getAsJsonArray((JsonObject)jsonobject, (String)"uniforms", null)) != null) {
            int l = 0;
            for (JsonElement jsonelement1 : jsonarray1) {
                try {
                    this.parseUniformNode(jsonelement1);
                }
                catch (Exception exception) {
                    ChainedJsonException chainedjsonexception1 = ChainedJsonException.forException((Exception)exception);
                    chainedjsonexception1.prependJsonKey("uniforms[" + l + "]");
                    throw chainedjsonexception1;
                }
                ++l;
            }
        }
    }

    private void parseUniformNode(JsonElement p_110048_) throws ChainedJsonException {
        JsonObject jsonobject = GsonHelper.convertToJsonObject((JsonElement)p_110048_, (String)"uniform");
        String s = GsonHelper.getAsString((JsonObject)jsonobject, (String)"name");
        Uniform uniform = this.passes.get(this.passes.size() - 1).getEffect().getUniform(s);
        if (uniform == null) {
            throw new ChainedJsonException("Uniform '" + s + "' does not exist");
        }
        float[] afloat = new float[4];
        int i = 0;
        for (JsonElement jsonelement : GsonHelper.getAsJsonArray((JsonObject)jsonobject, (String)"values")) {
            try {
                afloat[i] = GsonHelper.convertToFloat((JsonElement)jsonelement, (String)"value");
            }
            catch (Exception exception) {
                ChainedJsonException chainedjsonexception = ChainedJsonException.forException((Exception)exception);
                chainedjsonexception.prependJsonKey("values[" + i + "]");
                throw chainedjsonexception;
            }
            ++i;
        }
        switch (i) {
            default: {
                break;
            }
            case 1: {
                uniform.set(afloat[0]);
                break;
            }
            case 2: {
                uniform.set(afloat[0], afloat[1]);
                break;
            }
            case 3: {
                uniform.set(afloat[0], afloat[1], afloat[2]);
                break;
            }
            case 4: {
                uniform.set(afloat[0], afloat[1], afloat[2], afloat[3]);
            }
        }
    }

    public RenderTarget getTempTarget(String p_110037_) {
        return this.customRenderTargets.get(p_110037_);
    }

    public void addTempTarget(String p_110039_, int p_110040_, int p_110041_) {
        TextureTarget rendertarget = new TextureTarget(p_110040_, p_110041_, true, Minecraft.ON_OSX);
        rendertarget.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        if (this.screenTarget.isStencilEnabled()) {
            rendertarget.enableStencil();
        }
        this.customRenderTargets.put(p_110039_, (RenderTarget)rendertarget);
        if (p_110040_ == this.screenWidth && p_110041_ == this.screenHeight) {
            this.fullSizedTargets.add((RenderTarget)rendertarget);
        }
    }

    @Override
    public void close() {
        for (RenderTarget rendertarget : this.customRenderTargets.values()) {
            rendertarget.destroyBuffers();
        }
        for (PostPass postpass : this.passes) {
            postpass.close();
        }
        this.passes.clear();
    }

    public PostPass addPass(String p_110043_, RenderTarget p_110044_, RenderTarget p_110045_, boolean p_334079_) throws IOException {
        PostPass postpass = new PostPass(this.resourceProvider, p_110043_, p_110044_, p_110045_, p_334079_);
        this.passes.add(this.passes.size(), postpass);
        return postpass;
    }

    private void updateOrthoMatrix() {
        this.shaderOrthoMatrix = new Matrix4f().setOrtho(0.0f, (float)this.screenTarget.width, 0.0f, (float)this.screenTarget.height, 0.1f, 1000.0f);
    }

    public void resize(int p_110026_, int p_110027_) {
        this.screenWidth = this.screenTarget.width;
        this.screenHeight = this.screenTarget.height;
        this.updateOrthoMatrix();
        for (PostPass postpass : this.passes) {
            postpass.setOrthoMatrix(this.shaderOrthoMatrix);
        }
        for (RenderTarget rendertarget : this.fullSizedTargets) {
            rendertarget.resize(p_110026_, p_110027_, Minecraft.ON_OSX);
        }
    }

    private void setFilterMode(int p_333852_) {
        this.screenTarget.setFilterMode(p_333852_);
        for (RenderTarget rendertarget : this.customRenderTargets.values()) {
            rendertarget.setFilterMode(p_333852_);
        }
    }

    public void process(float p_110024_) {
        this.time += p_110024_;
        while (this.time > 20.0f) {
            this.time -= 20.0f;
        }
        int i = 9728;
        for (PostPass postpass : this.passes) {
            int j = postpass.getFilterMode();
            if (i != j) {
                this.setFilterMode(j);
                i = j;
            }
            postpass.process(this.time / 20.0f);
        }
        this.setFilterMode(9728);
    }

    public void setUniform(String p_332204_, float p_331999_) {
        for (PostPass postpass : this.passes) {
            postpass.getEffect().safeGetUniform(p_332204_).set(p_331999_);
        }
    }

    public final String getName() {
        return this.name;
    }

    @Nullable
    private RenderTarget getRenderTarget(@Nullable String p_110050_) {
        if (p_110050_ == null) {
            return null;
        }
        return p_110050_.equals(MAIN_RENDER_TARGET) ? this.screenTarget : this.customRenderTargets.get(p_110050_);
    }
}

