/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TridentItem
extends Item
implements ProjectileItem {
    public static final int THROW_THRESHOLD_TIME = 10;
    public static final float BASE_DAMAGE = 8.0f;
    public static final float SHOOT_POWER = 2.5f;

    public TridentItem(Item.Properties p_43381_) {
        super(p_43381_);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 8.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.9f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    @Override
    public boolean canAttackBlock(BlockState p_43409_, Level p_43410_, BlockPos p_43411_, Player p_43412_) {
        return !p_43412_.isCreative();
    }

    @Override
    public UseAnim getUseAnimation(ItemStack p_43417_) {
        return UseAnim.SPEAR;
    }

    @Override
    public int getUseDuration(ItemStack p_43419_, LivingEntity p_345001_) {
        return 72000;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void releaseUsing(ItemStack p_43394_, Level p_43395_, LivingEntity p_43396_, int p_43397_) {
        void $$5;
        if (!(p_43396_ instanceof Player)) {
            return;
        }
        Player $$4 = (Player)p_43396_;
        int $$6 = this.getUseDuration(p_43394_, p_43396_) - p_43397_;
        if ($$6 < 10) {
            return;
        }
        float $$7 = EnchantmentHelper.getTridentSpinAttackStrength(p_43394_, (LivingEntity)$$5);
        if ($$7 > 0.0f && !$$5.isInWaterOrRain()) {
            return;
        }
        if (TridentItem.isTooDamagedToUse(p_43394_)) {
            return;
        }
        Holder<SoundEvent> $$8 = EnchantmentHelper.pickHighestLevel(p_43394_, EnchantmentEffectComponents.TRIDENT_SOUND).orElse(SoundEvents.TRIDENT_THROW);
        if (!p_43395_.isClientSide) {
            p_43394_.hurtAndBreak(1, (LivingEntity)$$5, LivingEntity.getSlotForHand(p_43396_.getUsedItemHand()));
            if ($$7 == 0.0f) {
                ThrownTrident $$9 = new ThrownTrident(p_43395_, (LivingEntity)$$5, p_43394_);
                $$9.shootFromRotation((Entity)$$5, $$5.getXRot(), $$5.getYRot(), 0.0f, 2.5f, 1.0f);
                if ($$5.hasInfiniteMaterials()) {
                    $$9.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                p_43395_.addFreshEntity($$9);
                p_43395_.playSound(null, $$9, $$8.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!$$5.hasInfiniteMaterials()) {
                    $$5.getInventory().removeItem(p_43394_);
                }
            }
        }
        $$5.awardStat(Stats.ITEM_USED.get(this));
        if ($$7 > 0.0f) {
            float $$10 = $$5.getYRot();
            float $$11 = $$5.getXRot();
            float $$12 = -Mth.sin($$10 * ((float)Math.PI / 180)) * Mth.cos($$11 * ((float)Math.PI / 180));
            float $$13 = -Mth.sin($$11 * ((float)Math.PI / 180));
            float $$14 = Mth.cos($$10 * ((float)Math.PI / 180)) * Mth.cos($$11 * ((float)Math.PI / 180));
            float $$15 = Mth.sqrt($$12 * $$12 + $$13 * $$13 + $$14 * $$14);
            $$5.push($$12 *= $$7 / $$15, $$13 *= $$7 / $$15, $$14 *= $$7 / $$15);
            $$5.startAutoSpinAttack(20, 8.0f, p_43394_);
            if ($$5.onGround()) {
                float $$16 = 1.1999999f;
                $$5.move(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
            }
            p_43395_.playSound(null, (Entity)$$5, $$8.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level p_43405_, Player p_43406_, InteractionHand p_43407_) {
        ItemStack $$3 = p_43406_.getItemInHand(p_43407_);
        if (TridentItem.isTooDamagedToUse($$3)) {
            return InteractionResultHolder.fail($$3);
        }
        if (EnchantmentHelper.getTridentSpinAttackStrength($$3, p_43406_) > 0.0f && !p_43406_.isInWaterOrRain()) {
            return InteractionResultHolder.fail($$3);
        }
        p_43406_.startUsingItem(p_43407_);
        return InteractionResultHolder.consume($$3);
    }

    private static boolean isTooDamagedToUse(ItemStack p_353073_) {
        return p_353073_.getDamageValue() >= p_353073_.getMaxDamage() - 1;
    }

    @Override
    public boolean hurtEnemy(ItemStack p_43390_, LivingEntity p_43391_, LivingEntity p_43392_) {
        return true;
    }

    @Override
    public void postHurtEnemy(ItemStack p_345950_, LivingEntity p_345617_, LivingEntity p_345537_) {
        p_345950_.hurtAndBreak(1, p_345537_, EquipmentSlot.MAINHAND);
    }

    @Override
    public int getEnchantmentValue() {
        return 1;
    }

    @Override
    public Projectile asProjectile(Level p_338505_, Position p_338277_, ItemStack p_338353_, Direction p_338220_) {
        ThrownTrident $$4 = new ThrownTrident(p_338505_, p_338277_.x(), p_338277_.y(), p_338277_.z(), p_338353_.copyWithCount(1));
        $$4.pickup = AbstractArrow.Pickup.ALLOWED;
        return $$4;
    }
}

