/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.authlib.GameProfile;
import java.time.Duration;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.chat.SignedMessageValidator;
import net.minecraft.util.SignatureValidator;
import net.minecraft.world.entity.player.ProfilePublicKey;

public record RemoteChatSession(UUID sessionId, ProfilePublicKey profilePublicKey) {
    public SignedMessageValidator createMessageValidator(Duration p_298238_) {
        return new SignedMessageValidator.KeyBased(this.profilePublicKey.createSignatureValidator(), () -> this.profilePublicKey.data().hasExpired(p_298238_));
    }

    public SignedMessageChain.Decoder createMessageDecoder(UUID p_249107_) {
        return new SignedMessageChain(p_249107_, this.sessionId).decoder(this.profilePublicKey);
    }

    public Data asData() {
        return new Data(this.sessionId, this.profilePublicKey.data());
    }

    public boolean hasExpired() {
        return this.profilePublicKey.data().hasExpired();
    }

    public record Data(UUID sessionId, ProfilePublicKey.Data profilePublicKey) {
        public static Data read(FriendlyByteBuf p_252181_) {
            return new Data(p_252181_.readUUID(), new ProfilePublicKey.Data(p_252181_));
        }

        public static void write(FriendlyByteBuf p_248910_, Data p_250537_) {
            p_248910_.writeUUID(p_250537_.sessionId);
            p_250537_.profilePublicKey.write(p_248910_);
        }

        public RemoteChatSession validate(GameProfile p_251231_, SignatureValidator p_248970_) throws ProfilePublicKey.ValidationException {
            return new RemoteChatSession(this.sessionId, ProfilePublicKey.createValidated(p_248970_, p_251231_.getId(), this.profilePublicKey));
        }
    }
}

