/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;
import net.minecraft.util.DelegateDataOutput;
import net.minecraft.util.FastBufferedInputStream;

public class NbtIo {
    private static final OpenOption[] SYNC_OUTPUT_OPTIONS = new OpenOption[]{StandardOpenOption.SYNC, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};

    public static CompoundTag readCompressed(Path p_309661_, NbtAccounter p_307351_) throws IOException {
        try (InputStream $$2 = Files.newInputStream(p_309661_, new OpenOption[0]);){
            CompoundTag compoundTag;
            try (FastBufferedInputStream $$3 = new FastBufferedInputStream($$2);){
                compoundTag = NbtIo.readCompressed($$3, p_307351_);
            }
            return compoundTag;
        }
    }

    private static DataInputStream createDecompressorStream(InputStream p_202494_) throws IOException {
        return new DataInputStream(new FastBufferedInputStream(new GZIPInputStream(p_202494_)));
    }

    private static DataOutputStream createCompressorStream(OutputStream p_309656_) throws IOException {
        return new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(p_309656_)));
    }

    public static CompoundTag readCompressed(InputStream p_307406_, NbtAccounter p_307479_) throws IOException {
        try (DataInputStream $$2 = NbtIo.createDecompressorStream(p_307406_);){
            CompoundTag compoundTag = NbtIo.read($$2, p_307479_);
            return compoundTag;
        }
    }

    public static void parseCompressed(Path p_309564_, StreamTagVisitor p_202489_, NbtAccounter p_302378_) throws IOException {
        try (InputStream $$3 = Files.newInputStream(p_309564_, new OpenOption[0]);
             FastBufferedInputStream $$4 = new FastBufferedInputStream($$3);){
            NbtIo.parseCompressed($$4, p_202489_, p_302378_);
        }
    }

    public static void parseCompressed(InputStream p_202491_, StreamTagVisitor p_202492_, NbtAccounter p_302334_) throws IOException {
        try (DataInputStream $$3 = NbtIo.createDecompressorStream(p_202491_);){
            NbtIo.parse($$3, p_202492_, p_302334_);
        }
    }

    public static void writeCompressed(CompoundTag p_128945_, Path p_309705_) throws IOException {
        try (OutputStream $$2 = Files.newOutputStream(p_309705_, SYNC_OUTPUT_OPTIONS);
             BufferedOutputStream $$3 = new BufferedOutputStream($$2);){
            NbtIo.writeCompressed(p_128945_, $$3);
        }
    }

    public static void writeCompressed(CompoundTag p_128948_, OutputStream p_128949_) throws IOException {
        try (DataOutputStream $$2 = NbtIo.createCompressorStream(p_128949_);){
            NbtIo.write(p_128948_, $$2);
        }
    }

    public static void write(CompoundTag p_128956_, Path p_309549_) throws IOException {
        try (OutputStream $$2 = Files.newOutputStream(p_309549_, SYNC_OUTPUT_OPTIONS);
             BufferedOutputStream $$3 = new BufferedOutputStream($$2);
             DataOutputStream $$4 = new DataOutputStream($$3);){
            NbtIo.write(p_128956_, $$4);
        }
    }

    @Nullable
    public static CompoundTag read(Path p_309563_) throws IOException {
        if (!Files.exists(p_309563_, new LinkOption[0])) {
            return null;
        }
        try (InputStream $$1 = Files.newInputStream(p_309563_, new OpenOption[0]);){
            CompoundTag compoundTag;
            try (DataInputStream $$2 = new DataInputStream($$1);){
                compoundTag = NbtIo.read($$2, NbtAccounter.unlimitedHeap());
            }
            return compoundTag;
        }
    }

    public static CompoundTag read(DataInput p_128929_) throws IOException {
        return NbtIo.read(p_128929_, NbtAccounter.unlimitedHeap());
    }

    public static CompoundTag read(DataInput p_128935_, NbtAccounter p_128936_) throws IOException {
        Tag $$2 = NbtIo.readUnnamedTag(p_128935_, p_128936_);
        if ($$2 instanceof CompoundTag) {
            return (CompoundTag)$$2;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void write(CompoundTag p_128942_, DataOutput p_128943_) throws IOException {
        NbtIo.writeUnnamedTagWithFallback(p_128942_, p_128943_);
    }

    public static void parse(DataInput p_197510_, StreamTagVisitor p_197511_, NbtAccounter p_302331_) throws IOException {
        TagType<?> $$3 = TagTypes.getType(p_197510_.readByte());
        if ($$3 == EndTag.TYPE) {
            if (p_197511_.visitRootEntry(EndTag.TYPE) == StreamTagVisitor.ValueResult.CONTINUE) {
                p_197511_.visitEnd();
            }
            return;
        }
        switch (p_197511_.visitRootEntry($$3)) {
            case HALT: {
                break;
            }
            case BREAK: {
                StringTag.skipString(p_197510_);
                $$3.skip(p_197510_, p_302331_);
                break;
            }
            case CONTINUE: {
                StringTag.skipString(p_197510_);
                $$3.parse(p_197510_, p_197511_, p_302331_);
            }
        }
    }

    public static Tag readAnyTag(DataInput p_294481_, NbtAccounter p_294287_) throws IOException {
        byte $$2 = p_294481_.readByte();
        if ($$2 == 0) {
            return EndTag.INSTANCE;
        }
        return NbtIo.readTagSafe(p_294481_, p_294287_, $$2);
    }

    public static void writeAnyTag(Tag p_294166_, DataOutput p_295552_) throws IOException {
        p_295552_.writeByte(p_294166_.getId());
        if (p_294166_.getId() == 0) {
            return;
        }
        p_294166_.write(p_295552_);
    }

    public static void writeUnnamedTag(Tag p_128951_, DataOutput p_128952_) throws IOException {
        p_128952_.writeByte(p_128951_.getId());
        if (p_128951_.getId() == 0) {
            return;
        }
        p_128952_.writeUTF("");
        p_128951_.write(p_128952_);
    }

    public static void writeUnnamedTagWithFallback(Tag p_311861_, DataOutput p_312306_) throws IOException {
        NbtIo.writeUnnamedTag(p_311861_, new StringFallbackDataOutput(p_312306_));
    }

    private static Tag readUnnamedTag(DataInput p_128931_, NbtAccounter p_128933_) throws IOException {
        byte $$2 = p_128931_.readByte();
        if ($$2 == 0) {
            return EndTag.INSTANCE;
        }
        StringTag.skipString(p_128931_);
        return NbtIo.readTagSafe(p_128931_, p_128933_, $$2);
    }

    private static Tag readTagSafe(DataInput p_295228_, NbtAccounter p_294806_, byte p_294992_) {
        try {
            return TagTypes.getType(p_294992_).load(p_295228_, p_294806_);
        }
        catch (IOException $$3) {
            CrashReport $$4 = CrashReport.forThrowable($$3, "Loading NBT data");
            CrashReportCategory $$5 = $$4.addCategory("NBT Tag");
            $$5.setDetail("Tag type", p_294992_);
            throw new ReportedNbtException($$4);
        }
    }

    public static class StringFallbackDataOutput
    extends DelegateDataOutput {
        public StringFallbackDataOutput(DataOutput p_312308_) {
            super(p_312308_);
        }

        @Override
        public void writeUTF(String p_312136_) throws IOException {
            try {
                super.writeUTF(p_312136_);
            }
            catch (UTFDataFormatException $$1) {
                Util.logAndPauseIfInIde("Failed to write NBT String", $$1);
                super.writeUTF("");
            }
        }
    }
}

