/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class SnbtToNbt
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackOutput output;
    private final Iterable<Path> inputFolders;
    private final List<Filter> filters = Lists.newArrayList();

    public SnbtToNbt(PackOutput p_249104_, Iterable<Path> p_249523_) {
        this.output = p_249104_;
        this.inputFolders = p_249523_;
    }

    public SnbtToNbt addFilter(Filter p_126476_) {
        this.filters.add(p_126476_);
        return this;
    }

    private CompoundTag applyFilters(String p_126461_, CompoundTag p_126462_) {
        CompoundTag $$2 = p_126462_;
        for (Filter $$3 : this.filters) {
            $$2 = $$3.apply(p_126461_, $$2);
        }
        return $$2;
    }

    @Override
    public CompletableFuture<?> run(CachedOutput p_254336_) {
        Path $$1 = this.output.getOutputFolder();
        ArrayList $$2 = Lists.newArrayList();
        for (Path $$3 : this.inputFolders) {
            $$2.add(CompletableFuture.supplyAsync(() -> {
                CompletableFuture<Void> completableFuture;
                block8: {
                    Stream<Path> $$3 = Files.walk($$3, new FileVisitOption[0]);
                    try {
                        completableFuture = CompletableFuture.allOf((CompletableFuture[])$$3.filter(p_126464_ -> p_126464_.toString().endsWith(".snbt")).map(p_253432_ -> CompletableFuture.runAsync(() -> {
                            TaskResult $$4 = this.readStructure((Path)p_253432_, this.getName($$3, (Path)p_253432_));
                            this.storeStructureIfChanged(p_254336_, $$4, $$1);
                        }, Util.backgroundExecutor())).toArray(CompletableFuture[]::new));
                        if ($$3 == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if ($$3 != null) {
                                try {
                                    $$3.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception $$4) {
                            throw new RuntimeException("Failed to read structure input directory, aborting", $$4);
                        }
                    }
                    $$3.close();
                }
                return completableFuture;
            }, Util.backgroundExecutor()).thenCompose(p_253441_ -> p_253441_));
        }
        return Util.sequenceFailFast($$2);
    }

    @Override
    public final String getName() {
        return "SNBT -> NBT";
    }

    private String getName(Path p_126469_, Path p_126470_) {
        String $$2 = p_126469_.relativize(p_126470_).toString().replaceAll("\\\\", "/");
        return $$2.substring(0, $$2.length() - ".snbt".length());
    }

    private TaskResult readStructure(Path p_126466_, String p_126467_) {
        TaskResult taskResult;
        block8: {
            BufferedReader $$2 = Files.newBufferedReader(p_126466_);
            try {
                String $$3 = IOUtils.toString((Reader)$$2);
                CompoundTag $$4 = this.applyFilters(p_126467_, NbtUtils.snbtToStructure($$3));
                ByteArrayOutputStream $$5 = new ByteArrayOutputStream();
                HashingOutputStream $$6 = new HashingOutputStream(Hashing.sha1(), (OutputStream)$$5);
                NbtIo.writeCompressed($$4, (OutputStream)$$6);
                byte[] $$7 = $$5.toByteArray();
                HashCode $$8 = $$6.hash();
                taskResult = new TaskResult(p_126467_, $$7, $$8);
                if ($$2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if ($$2 != null) {
                        try {
                            $$2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable $$9) {
                    throw new StructureConversionException(p_126466_, $$9);
                }
            }
            $$2.close();
        }
        return taskResult;
    }

    private void storeStructureIfChanged(CachedOutput p_236394_, TaskResult p_236395_, Path p_236396_) {
        Path $$3 = p_236396_.resolve(p_236395_.name + ".nbt");
        try {
            p_236394_.writeIfNeeded($$3, p_236395_.payload, p_236395_.hash);
        }
        catch (IOException $$4) {
            LOGGER.error("Couldn't write structure {} at {}", new Object[]{p_236395_.name, $$3, $$4});
        }
    }

    @FunctionalInterface
    public static interface Filter {
        public CompoundTag apply(String var1, CompoundTag var2);
    }

    record TaskResult(String name, byte[] payload, HashCode hash) {
    }

    static class StructureConversionException
    extends RuntimeException {
        public StructureConversionException(Path p_176820_, Throwable p_176821_) {
            super(p_176820_.toAbsolutePath().toString(), p_176821_);
        }
    }
}

