/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.block.model.multipart.MultiPart;
import net.minecraft.client.renderer.block.model.multipart.Selector;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.slf4j.Logger;

public class BlockStateModelLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    static final int SINGLETON_MODEL_GROUP = -1;
    private static final int INVISIBLE_MODEL_GROUP = 0;
    public static final FileToIdConverter BLOCKSTATE_LISTER = FileToIdConverter.json("blockstates");
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);
    private static final StateDefinition<Block, BlockState> ITEM_FRAME_FAKE_DEFINITION = new StateDefinition.Builder(Blocks.AIR).add(BooleanProperty.create("map")).create(Block::defaultBlockState, BlockState::new);
    private static final Map<ResourceLocation, StateDefinition<Block, BlockState>> STATIC_DEFINITIONS = Map.of(ResourceLocation.withDefaultNamespace("item_frame"), ITEM_FRAME_FAKE_DEFINITION, ResourceLocation.withDefaultNamespace("glow_item_frame"), ITEM_FRAME_FAKE_DEFINITION);
    private final Map<ResourceLocation, List<LoadedJson>> blockStateResources;
    private final ProfilerFiller profiler;
    private final BlockColors blockColors;
    private final BiConsumer<ModelResourceLocation, UnbakedModel> discoveredModelOutput;
    private int nextModelGroup = 1;
    private final Object2IntMap<BlockState> modelGroups = (Object2IntMap)Util.make(new Object2IntOpenHashMap(), p_352094_ -> p_352094_.defaultReturnValue(-1));
    private final LoadedModel missingModel;
    private final BlockModelDefinition.Context context = new BlockModelDefinition.Context();

    public BlockStateModelLoader(Map<ResourceLocation, List<LoadedJson>> p_352185_, ProfilerFiller p_352252_, UnbakedModel p_352193_, BlockColors p_352120_, BiConsumer<ModelResourceLocation, UnbakedModel> p_352414_) {
        this.blockStateResources = p_352185_;
        this.profiler = p_352252_;
        this.blockColors = p_352120_;
        this.discoveredModelOutput = p_352414_;
        ModelGroupKey $$5 = new ModelGroupKey(List.of(p_352193_), List.of());
        this.missingModel = new LoadedModel(p_352193_, () -> $$5);
    }

    public void loadAllBlockStates() {
        this.profiler.push("static_definitions");
        STATIC_DEFINITIONS.forEach(this::loadBlockStateDefinitions);
        this.profiler.popPush("blocks");
        for (Block $$0 : BuiltInRegistries.BLOCK) {
            this.loadBlockStateDefinitions($$0.builtInRegistryHolder().key().location(), $$0.getStateDefinition());
        }
        this.profiler.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBlockStateDefinitions(ResourceLocation p_352059_, StateDefinition<Block, BlockState> p_352064_) {
        this.context.setDefinition(p_352064_);
        List<Property<?>> $$2 = List.copyOf(this.blockColors.getColoringProperties(p_352064_.getOwner()));
        ImmutableList<BlockState> $$3 = p_352064_.getPossibleStates();
        HashMap<ModelResourceLocation, BlockState> $$4 = new HashMap<ModelResourceLocation, BlockState>();
        $$3.forEach(p_352345_ -> $$4.put(BlockModelShaper.stateToModelLocation(p_352059_, p_352345_), (BlockState)p_352345_));
        HashMap $$5 = new HashMap();
        ResourceLocation $$6 = BLOCKSTATE_LISTER.idToFile(p_352059_);
        try {
            for (LoadedJson $$7 : this.blockStateResources.getOrDefault($$6, List.of())) {
                MultiPart $$11;
                BlockModelDefinition $$8 = $$7.parse(p_352059_, this.context);
                IdentityHashMap $$9 = new IdentityHashMap();
                if ($$8.isMultiPart()) {
                    MultiPart $$10 = $$8.getMultiPart();
                    $$3.forEach(p_352430_ -> $$9.put(p_352430_, new LoadedModel($$10, () -> ModelGroupKey.create(p_352430_, $$10, $$2))));
                } else {
                    $$11 = null;
                }
                $$8.getVariants().forEach((p_352346_, p_352105_) -> {
                    try {
                        $$3.stream().filter(BlockStateModelLoader.predicate(p_352064_, p_352346_)).forEach(p_352306_ -> {
                            LoadedModel $$6 = $$9.put(p_352306_, new LoadedModel((UnbakedModel)p_352105_, () -> ModelGroupKey.create(p_352306_, p_352105_, $$2)));
                            if ($$6 != null && $$6.model != $$11) {
                                $$9.put(p_352306_, this.missingModel);
                                throw new RuntimeException("Overlapping definition with: " + (String)$$8.getVariants().entrySet().stream().filter(p_352224_ -> p_352224_.getValue() == p_352160_.model).findFirst().get().getKey());
                            }
                        });
                    }
                    catch (Exception $$10) {
                        LOGGER.warn("Exception loading blockstate definition: '{}' in resourcepack: '{}' for variant: '{}': {}", new Object[]{$$6, p_352437_.source, p_352346_, $$10.getMessage()});
                    }
                });
                $$5.putAll($$9);
            }
        }
        catch (BlockStateDefinitionException $$13) {
            LOGGER.warn("{}", (Object)$$13.getMessage());
        }
        catch (Exception $$15) {
            LOGGER.warn("Exception loading blockstate definition: '{}'", (Object)$$6, (Object)$$15);
        }
        finally {
            HashMap<ModelGroupKey, Set> $$14 = new HashMap<ModelGroupKey, Set>();
            $$4.forEach((p_352171_, p_352134_) -> {
                LoadedModel $$5 = (LoadedModel)$$5.get(p_352134_);
                if ($$5 == null) {
                    LOGGER.warn("Exception loading blockstate definition: '{}' missing model for variant: '{}'", (Object)$$6, p_352171_);
                    $$5 = this.missingModel;
                }
                this.discoveredModelOutput.accept((ModelResourceLocation)p_352171_, $$5.model);
                try {
                    ModelGroupKey $$6 = $$5.key().get();
                    $$14.computeIfAbsent($$6, p_352112_ -> Sets.newIdentityHashSet()).add(p_352134_);
                }
                catch (Exception $$7) {
                    LOGGER.warn("Exception evaluating model definition: '{}'", p_352171_, (Object)$$7);
                }
            });
            $$14.forEach((p_352263_, p_352463_) -> {
                Iterator $$2 = p_352463_.iterator();
                while ($$2.hasNext()) {
                    BlockState $$3 = (BlockState)$$2.next();
                    if ($$3.getRenderShape() == RenderShape.MODEL) continue;
                    $$2.remove();
                    this.modelGroups.put((Object)$$3, 0);
                }
                if (p_352463_.size() > 1) {
                    this.registerModelGroup((Iterable<BlockState>)p_352463_);
                }
            });
        }
    }

    private static Predicate<BlockState> predicate(StateDefinition<Block, BlockState> p_352099_, String p_352078_) {
        HashMap $$2 = new HashMap();
        for (String $$3 : COMMA_SPLITTER.split((CharSequence)p_352078_)) {
            Iterator $$4 = EQUAL_SPLITTER.split((CharSequence)$$3).iterator();
            if (!$$4.hasNext()) continue;
            String $$5 = (String)$$4.next();
            Property<?> $$6 = p_352099_.getProperty($$5);
            if ($$6 != null && $$4.hasNext()) {
                String $$7 = (String)$$4.next();
                Object $$8 = BlockStateModelLoader.getValueHelper($$6, $$7);
                if ($$8 != null) {
                    $$2.put($$6, $$8);
                    continue;
                }
                throw new RuntimeException("Unknown value: '" + $$7 + "' for blockstate property: '" + $$5 + "' " + String.valueOf($$6.getPossibleValues()));
            }
            if ($$5.isEmpty()) continue;
            throw new RuntimeException("Unknown blockstate property: '" + $$5 + "'");
        }
        Block $$9 = p_352099_.getOwner();
        return p_352368_ -> {
            if (p_352368_ == null || !p_352368_.is($$9)) {
                return false;
            }
            for (Map.Entry $$3 : $$2.entrySet()) {
                if (Objects.equals(p_352368_.getValue((Property)$$3.getKey()), $$3.getValue())) continue;
                return false;
            }
            return true;
        };
    }

    @Nullable
    static <T extends Comparable<T>> T getValueHelper(Property<T> p_352301_, String p_352273_) {
        return (T)((Comparable)p_352301_.getValue(p_352273_).orElse(null));
    }

    private void registerModelGroup(Iterable<BlockState> p_352382_) {
        int $$1 = this.nextModelGroup++;
        p_352382_.forEach(p_352170_ -> this.modelGroups.put(p_352170_, $$1));
    }

    public Object2IntMap<BlockState> getModelGroups() {
        return this.modelGroups;
    }

    record ModelGroupKey(List<UnbakedModel> models, List<Object> coloringValues) {
        public static ModelGroupKey create(BlockState p_352381_, MultiPart p_352248_, Collection<Property<?>> p_352227_) {
            StateDefinition<Block, BlockState> $$3 = p_352381_.getBlock().getStateDefinition();
            List<UnbakedModel> $$4 = p_352248_.getSelectors().stream().filter(p_352283_ -> p_352283_.getPredicate($$3).test(p_352381_)).map(Selector::getVariant).collect(Collectors.toUnmodifiableList());
            List<Object> $$5 = ModelGroupKey.getColoringValues(p_352381_, p_352227_);
            return new ModelGroupKey($$4, $$5);
        }

        public static ModelGroupKey create(BlockState p_352440_, UnbakedModel p_352383_, Collection<Property<?>> p_352085_) {
            List<Object> $$3 = ModelGroupKey.getColoringValues(p_352440_, p_352085_);
            return new ModelGroupKey(List.of(p_352383_), $$3);
        }

        private static List<Object> getColoringValues(BlockState p_352214_, Collection<Property<?>> p_352157_) {
            return p_352157_.stream().map(p_352214_::getValue).collect(Collectors.toUnmodifiableList());
        }
    }

    record LoadedModel(UnbakedModel model, Supplier<ModelGroupKey> key) {
    }

    public record LoadedJson(String source, JsonElement data) {
        BlockModelDefinition parse(ResourceLocation p_352102_, BlockModelDefinition.Context p_352217_) {
            try {
                return BlockModelDefinition.fromJsonElement(p_352217_, this.data);
            }
            catch (Exception $$2) {
                throw new BlockStateDefinitionException(String.format(Locale.ROOT, "Exception loading blockstate definition: '%s' in resourcepack: '%s': %s", p_352102_, this.source, $$2.getMessage()));
            }
        }
    }

    static class BlockStateDefinitionException
    extends RuntimeException {
        public BlockStateDefinitionException(String p_352118_) {
            super(p_352118_);
        }
    }
}

