/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture.atlas;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.sources.DirectoryLister;
import net.minecraft.client.renderer.texture.atlas.sources.PalettedPermutations;
import net.minecraft.client.renderer.texture.atlas.sources.SingleFile;
import net.minecraft.client.renderer.texture.atlas.sources.SourceFilter;
import net.minecraft.client.renderer.texture.atlas.sources.Unstitcher;
import net.minecraft.resources.ResourceLocation;

public class SpriteSources {
    private static final BiMap<ResourceLocation, SpriteSourceType> TYPES = HashBiMap.create();
    public static final SpriteSourceType SINGLE_FILE = SpriteSources.register("single", SingleFile.CODEC);
    public static final SpriteSourceType DIRECTORY = SpriteSources.register("directory", DirectoryLister.CODEC);
    public static final SpriteSourceType FILTER = SpriteSources.register("filter", SourceFilter.CODEC);
    public static final SpriteSourceType UNSTITCHER = SpriteSources.register("unstitch", Unstitcher.CODEC);
    public static final SpriteSourceType PALETTED_PERMUTATIONS = SpriteSources.register("paletted_permutations", PalettedPermutations.CODEC);
    public static Codec<SpriteSourceType> TYPE_CODEC = ResourceLocation.CODEC.flatXmap(p_274717_ -> {
        SpriteSourceType $$1 = (SpriteSourceType)TYPES.get(p_274717_);
        return $$1 != null ? DataResult.success((Object)$$1) : DataResult.error(() -> "Unknown type " + String.valueOf(p_274717_));
    }, p_274716_ -> {
        ResourceLocation $$1 = (ResourceLocation)TYPES.inverse().get(p_274716_);
        return p_274716_ != null ? DataResult.success((Object)$$1) : DataResult.error(() -> "Unknown type " + String.valueOf($$1));
    });
    public static Codec<SpriteSource> CODEC = TYPE_CODEC.dispatch(SpriteSource::type, SpriteSourceType::codec);
    public static Codec<List<SpriteSource>> FILE_CODEC = CODEC.listOf().fieldOf("sources").codec();

    private static SpriteSourceType register(String p_262175_, MapCodec<? extends SpriteSource> p_338536_) {
        SpriteSourceType $$2 = new SpriteSourceType(p_338536_);
        ResourceLocation $$3 = ResourceLocation.withDefaultNamespace(p_262175_);
        SpriteSourceType $$4 = (SpriteSourceType)TYPES.putIfAbsent((Object)$$3, (Object)$$2);
        if ($$4 != null) {
            throw new IllegalStateException("Duplicate registration " + String.valueOf($$3));
        }
        return $$2;
    }
}

