/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.animation.definitions.ArmadilloAnimation;
import net.minecraft.client.model.AgeableHierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.armadillo.Armadillo;

public class ArmadilloModel
extends AgeableHierarchicalModel<Armadillo> {
    private static final float BABY_Y_OFFSET = 16.02f;
    private static final float MAX_DOWN_HEAD_ROTATION_EXTENT = 25.0f;
    private static final float MAX_UP_HEAD_ROTATION_EXTENT = 22.5f;
    private static final float MAX_WALK_ANIMATION_SPEED = 16.5f;
    private static final float WALK_ANIMATION_SCALE_FACTOR = 2.5f;
    private static final String HEAD_CUBE = "head_cube";
    private static final String RIGHT_EAR_CUBE = "right_ear_cube";
    private static final String LEFT_EAR_CUBE = "left_ear_cube";
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart cube;
    private final ModelPart head;
    private final ModelPart tail;

    public ArmadilloModel(ModelPart p_316704_) {
        super(0.6f, 16.02f);
        this.root = p_316704_;
        this.body = p_316704_.getChild("body");
        this.rightHindLeg = p_316704_.getChild("right_hind_leg");
        this.leftHindLeg = p_316704_.getChild("left_hind_leg");
        this.head = this.body.getChild("head");
        this.tail = this.body.getChild("tail");
        this.cube = p_316704_.getChild("cube");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot();
        PartDefinition $$2 = $$1.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 20).addBox(-4.0f, -7.0f, -10.0f, 8.0f, 8.0f, 12.0f, new CubeDeformation(0.3f)).texOffs(0, 40).addBox(-4.0f, -7.0f, -10.0f, 8.0f, 8.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset(0.0f, 21.0f, 4.0f));
        $$2.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(44, 53).addBox(-0.5f, -0.0865f, 0.0933f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation(0.0f, -3.0f, 1.0f, 0.5061f, 0.0f, 0.0f));
        PartDefinition $$3 = $$2.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset(0.0f, -2.0f, -11.0f));
        $$3.addOrReplaceChild(HEAD_CUBE, CubeListBuilder.create().texOffs(43, 15).addBox(-1.5f, -1.0f, -1.0f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation(0.0f, 0.0f, 0.0f, -0.3927f, 0.0f, 0.0f));
        PartDefinition $$4 = $$3.addOrReplaceChild("right_ear", CubeListBuilder.create(), PartPose.offset(-1.0f, -1.0f, 0.0f));
        $$4.addOrReplaceChild(RIGHT_EAR_CUBE, CubeListBuilder.create().texOffs(43, 10).addBox(-2.0f, -3.0f, 0.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation(-0.5f, 0.0f, -0.6f, 0.1886f, -0.3864f, -0.0718f));
        PartDefinition $$5 = $$3.addOrReplaceChild("left_ear", CubeListBuilder.create(), PartPose.offset(1.0f, -2.0f, 0.0f));
        $$5.addOrReplaceChild(LEFT_EAR_CUBE, CubeListBuilder.create().texOffs(47, 10).addBox(0.0f, -3.0f, 0.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation(0.5f, 1.0f, -0.6f, 0.1886f, 0.3864f, 0.0718f));
        $$1.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(51, 31).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset(-2.0f, 21.0f, 4.0f));
        $$1.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(42, 31).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset(2.0f, 21.0f, 4.0f));
        $$1.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(51, 43).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset(-2.0f, 21.0f, -4.0f));
        $$1.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(42, 43).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset(2.0f, 21.0f, -4.0f));
        $$1.addOrReplaceChild("cube", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -10.0f, -6.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset(0.0f, 24.0f, 0.0f));
        return LayerDefinition.create($$0, 64, 64);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }

    @Override
    public void setupAnim(Armadillo p_316579_, float p_316251_, float p_316543_, float p_316697_, float p_316591_, float p_316280_) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        if (p_316579_.shouldHideInShell()) {
            this.body.skipDraw = true;
            this.leftHindLeg.visible = false;
            this.rightHindLeg.visible = false;
            this.tail.visible = false;
            this.cube.visible = true;
        } else {
            this.body.skipDraw = false;
            this.leftHindLeg.visible = true;
            this.rightHindLeg.visible = true;
            this.tail.visible = true;
            this.cube.visible = false;
            this.head.xRot = Mth.clamp(p_316280_, -22.5f, 25.0f) * ((float)Math.PI / 180);
            this.head.yRot = Mth.clamp(p_316591_, -32.5f, 32.5f) * ((float)Math.PI / 180);
        }
        this.animateWalk(ArmadilloAnimation.ARMADILLO_WALK, p_316251_, p_316543_, 16.5f, 2.5f);
        this.animate(p_316579_.rollOutAnimationState, ArmadilloAnimation.ARMADILLO_ROLL_OUT, p_316697_, 1.0f);
        this.animate(p_316579_.rollUpAnimationState, ArmadilloAnimation.ARMADILLO_ROLL_UP, p_316697_, 1.0f);
        this.animate(p_316579_.peekAnimationState, ArmadilloAnimation.ARMADILLO_PEEK, p_316697_, 1.0f);
    }
}

