/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.client;

import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.exception.RealmsHttpException;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;

public interface RealmsError {
    public static final Component NO_MESSAGE = Component.translatable("mco.errorMessage.noDetails");
    public static final Logger LOGGER = LogUtils.getLogger();

    public int errorCode();

    public Component errorMessage();

    public String logMessage();

    public static RealmsError parse(int p_294532_, String p_87304_) {
        if (p_294532_ == 429) {
            return CustomError.SERVICE_BUSY;
        }
        if (Strings.isNullOrEmpty((String)p_87304_)) {
            return CustomError.noPayload(p_294532_);
        }
        try {
            JsonObject $$2 = JsonParser.parseString((String)p_87304_).getAsJsonObject();
            String $$3 = GsonHelper.getAsString($$2, "reason", null);
            String $$4 = GsonHelper.getAsString($$2, "errorMsg", null);
            int $$5 = GsonHelper.getAsInt($$2, "errorCode", -1);
            if ($$4 != null || $$3 != null || $$5 != -1) {
                return new ErrorWithJsonPayload(p_294532_, $$5 != -1 ? $$5 : p_294532_, $$3, $$4);
            }
        }
        catch (Exception $$6) {
            LOGGER.error("Could not parse RealmsError", (Throwable)$$6);
        }
        return new ErrorWithRawPayload(p_294532_, p_87304_);
    }

    public record CustomError(int httpCode, @Nullable Component payload) implements RealmsError
    {
        public static final CustomError SERVICE_BUSY = new CustomError(429, Component.translatable("mco.errorMessage.serviceBusy"));
        public static final Component RETRY_MESSAGE = Component.translatable("mco.errorMessage.retry");

        public static CustomError unknownCompatibilityResponse(String p_294662_) {
            return new CustomError(500, Component.translatable("mco.errorMessage.realmsService.unknownCompatibility", p_294662_));
        }

        public static CustomError connectivityError(RealmsHttpException p_294863_) {
            return new CustomError(500, Component.translatable("mco.errorMessage.realmsService.connectivity", p_294863_.getMessage()));
        }

        public static CustomError retry(int p_295020_) {
            return new CustomError(p_295020_, RETRY_MESSAGE);
        }

        public static CustomError noPayload(int p_295243_) {
            return new CustomError(p_295243_, null);
        }

        @Override
        public int errorCode() {
            return this.httpCode;
        }

        @Override
        public Component errorMessage() {
            return this.payload != null ? this.payload : NO_MESSAGE;
        }

        @Override
        public String logMessage() {
            if (this.payload != null) {
                return String.format(Locale.ROOT, "Realms service error (%d) with message '%s'", this.httpCode, this.payload.getString());
            }
            return String.format(Locale.ROOT, "Realms service error (%d) with no payload", this.httpCode);
        }
    }

    public record ErrorWithJsonPayload(int httpCode, int code, @Nullable String reason, @Nullable String message) implements RealmsError
    {
        @Override
        public int errorCode() {
            return this.code;
        }

        @Override
        public Component errorMessage() {
            String $$1;
            String $$0 = "mco.errorMessage." + this.code;
            if (I18n.exists($$0)) {
                return Component.translatable($$0);
            }
            if (this.reason != null && I18n.exists($$1 = "mco.errorReason." + this.reason)) {
                return Component.translatable($$1);
            }
            return this.message != null ? Component.literal(this.message) : NO_MESSAGE;
        }

        @Override
        public String logMessage() {
            return String.format(Locale.ROOT, "Realms service error (%d/%d/%s) with message '%s'", this.httpCode, this.code, this.reason, this.message);
        }
    }

    public record ErrorWithRawPayload(int httpCode, String payload) implements RealmsError
    {
        @Override
        public int errorCode() {
            return this.httpCode;
        }

        @Override
        public Component errorMessage() {
            return Component.literal(this.payload);
        }

        @Override
        public String logMessage() {
            return String.format(Locale.ROOT, "Realms service error (%d) with raw payload '%s'", this.httpCode, this.payload);
        }
    }

    public record AuthenticationError(String message) implements RealmsError
    {
        public static final int ERROR_CODE = 401;

        @Override
        public int errorCode() {
            return 401;
        }

        @Override
        public Component errorMessage() {
            return Component.literal(this.message);
        }

        @Override
        public String logMessage() {
            return String.format(Locale.ROOT, "Realms authentication error with message '%s'", this.message);
        }
    }
}

