/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.forgewrapper.installer.util;

import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import sun.misc.Unsafe;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ModuleUtil {
    private static final MethodHandles.Lookup IMPL_LOOKUP = ModuleUtil.getImplLookup();

    private static MethodHandles.Lookup getImplLookup() {
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            Unsafe unsafe = (Unsafe)unsafeField.get(null);
            Field implLookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            return (MethodHandles.Lookup)unsafe.getObject(unsafe.staticFieldBase(implLookupField), unsafe.staticFieldOffset(implLookupField));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static void addModules(String modulePath) throws Throwable {
        ModuleFinder finder = ModuleFinder.of((Path[])Stream.of(modulePath.split(File.pathSeparator)).map(x$0 -> Paths.get(x$0, new String[0])).filter(p -> ModuleFinder.of(p).findAll().stream().noneMatch(mref -> ModuleLayer.boot().findModule(mref.descriptor().name()).isPresent())).toArray(Path[]::new));
        MethodHandle loadModuleMH = IMPL_LOOKUP.findVirtual(Class.forName("jdk.internal.loader.BuiltinClassLoader"), "loadModule", MethodType.methodType(Void.TYPE, ModuleReference.class));
        ArrayList<String> roots = new ArrayList<String>();
        for (ModuleReference mref : finder.findAll()) {
            String name2 = mref.descriptor().name();
            if (ModuleLayer.boot().findModule(name2).isPresent()) continue;
            loadModuleMH.invokeWithArguments(ClassLoader.getSystemClassLoader(), mref);
            roots.add(name2);
        }
        Configuration config = Configuration.resolveAndBind(finder, List.of(ModuleLayer.boot().configuration()), finder, roots);
        MethodHandle graphGetter = IMPL_LOOKUP.findGetter(Configuration.class, "graph", Map.class);
        HashMap graphMap = new HashMap((Map)graphGetter.invokeWithArguments(config));
        MethodHandle cfSetter = IMPL_LOOKUP.findSetter(ResolvedModule.class, "cf", Configuration.class);
        for (Map.Entry entry : graphMap.entrySet()) {
            cfSetter.invokeWithArguments(entry.getKey(), ModuleLayer.boot().configuration());
            for (ResolvedModule resolvedModule : (Set)entry.getValue()) {
                cfSetter.invokeWithArguments(resolvedModule, ModuleLayer.boot().configuration());
            }
        }
        graphMap.putAll((Map)graphGetter.invokeWithArguments(ModuleLayer.boot().configuration()));
        IMPL_LOOKUP.findSetter(Configuration.class, "graph", Map.class).invokeWithArguments(ModuleLayer.boot().configuration(), new HashMap(graphMap));
        Set<ResolvedModule> oldBootModules = ModuleLayer.boot().configuration().modules();
        MethodHandle modulesSetter = IMPL_LOOKUP.findSetter(Configuration.class, "modules", Set.class);
        HashSet<ResolvedModule> modulesSet = new HashSet<ResolvedModule>(config.modules());
        modulesSetter.invokeWithArguments(ModuleLayer.boot().configuration(), new HashSet<ResolvedModule>(modulesSet));
        MethodHandle nameToModuleGetter = IMPL_LOOKUP.findGetter(Configuration.class, "nameToModule", Map.class);
        HashMap nameToModuleMap = new HashMap((Map)nameToModuleGetter.invokeWithArguments(ModuleLayer.boot().configuration()));
        nameToModuleMap.putAll((Map)nameToModuleGetter.invokeWithArguments(config));
        IMPL_LOOKUP.findSetter(Configuration.class, "nameToModule", Map.class).invokeWithArguments(ModuleLayer.boot().configuration(), new HashMap(nameToModuleMap));
        ((Map)IMPL_LOOKUP.findGetter(ModuleLayer.class, "nameToModule", Map.class).invokeWithArguments(ModuleLayer.boot())).putAll((Map)IMPL_LOOKUP.findStatic(Module.class, "defineModules", MethodType.methodType(Map.class, Configuration.class, Function.class, ModuleLayer.class)).invokeWithArguments(ModuleLayer.boot().configuration(), name -> ClassLoader.getSystemClassLoader(), ModuleLayer.boot()));
        modulesSet.addAll(oldBootModules);
        modulesSetter.invokeWithArguments(ModuleLayer.boot().configuration(), new HashSet<ResolvedModule>(modulesSet));
        IMPL_LOOKUP.findSetter(ModuleLayer.class, "modules", Set.class).invokeWithArguments(ModuleLayer.boot(), null);
        IMPL_LOOKUP.findSetter(ModuleLayer.class, "servicesCatalog", Class.forName("jdk.internal.module.ServicesCatalog")).invokeWithArguments(ModuleLayer.boot(), null);
        MethodHandle implAddReadsMH = IMPL_LOOKUP.findVirtual(Module.class, "implAddReads", MethodType.methodType(Void.TYPE, Module.class));
        for (ResolvedModule resolvedModule : config.modules()) {
            Module module = ModuleLayer.boot().findModule(resolvedModule.name()).orElse(null);
            if (module == null) continue;
            for (ResolvedModule bootResolvedModule : oldBootModules) {
                Module bootModule = ModuleLayer.boot().findModule(bootResolvedModule.name()).orElse(null);
                if (bootModule == null) continue;
                implAddReadsMH.invokeWithArguments(module, bootModule);
            }
        }
    }

    public static void addExports(List<String> exports) {
        TypeToAdd.EXPORTS.implAdd(exports);
    }

    public static void addOpens(List<String> opens) {
        TypeToAdd.OPENS.implAdd(opens);
    }

    public static ClassLoader getPlatformClassLoader() {
        return ClassLoader.getPlatformClassLoader();
    }

    private static Optional<ParserData> parseModuleExtra(String extra) {
        String[] all = extra.split("=", 2);
        if (all.length < 2) {
            return Optional.empty();
        }
        String[] source = all[0].split("/", 2);
        if (source.length < 2) {
            return Optional.empty();
        }
        return Optional.of(new ParserData(source[0], source[1], all[1]));
    }

    public static void setupClassPath(Path libraryDir, List<String> paths) throws Throwable {
        Class<?> urlClassPathClass = Class.forName("jdk.internal.loader.URLClassPath");
        Object ucp = IMPL_LOOKUP.findGetter(Class.forName("jdk.internal.loader.BuiltinClassLoader"), "ucp", urlClassPathClass).invokeWithArguments(ClassLoader.getSystemClassLoader());
        MethodHandle addURLMH = IMPL_LOOKUP.findVirtual(urlClassPathClass, "addURL", MethodType.methodType(Void.TYPE, URL.class));
        for (String path : paths) {
            addURLMH.invokeWithArguments(ucp, libraryDir.resolve(path).toUri().toURL());
        }
    }

    public static Class<?> setupBootstrapLauncher(Class<?> mainClass) throws Throwable {
        if (!mainClass.getModule().isOpen(mainClass.getPackageName(), ModuleUtil.class.getModule())) {
            TypeToAdd.OPENS.implAddMH.invokeWithArguments(mainClass.getModule(), mainClass.getPackageName(), ModuleUtil.class.getModule());
        }
        return mainClass;
    }

    private static class ParserData {
        final String module;
        final String packages;
        final String target;

        ParserData(String module, String packages, String target) {
            this.module = module;
            this.packages = packages;
            this.target = target;
        }
    }

    private static enum TypeToAdd {
        EXPORTS("Exports"),
        OPENS("Opens");

        private final MethodHandle implAddMH;
        private final MethodHandle implAddToAllUnnamedMH;

        private TypeToAdd(String name) {
            try {
                this.implAddMH = IMPL_LOOKUP.findVirtual(Module.class, "implAdd" + name, MethodType.methodType(Void.TYPE, String.class, Module.class));
                this.implAddToAllUnnamedMH = IMPL_LOOKUP.findVirtual(Module.class, "implAdd" + name + "ToAllUnnamed", MethodType.methodType(Void.TYPE, String.class));
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        void implAdd(List<String> extras) {
            for (String extra : extras) {
                Module module;
                ParserData data = ModuleUtil.parseModuleExtra(extra).orElse(null);
                if (data == null || (module = (Module)ModuleLayer.boot().findModule(data.module).orElse(null)) == null) continue;
                try {
                    if ("ALL-UNNAMED".equals(data.target)) {
                        this.implAddToAllUnnamedMH.invokeWithArguments(module, data.packages);
                        continue;
                    }
                    Module targetModule = ModuleLayer.boot().findModule(data.target).orElse(null);
                    if (targetModule == null) continue;
                    this.implAddMH.invokeWithArguments(module, data.packages, targetModule);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        }
    }
}

